/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.crypto.engine;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;

public class WrappingLambdaFuture<ReturnType, InnerReturnType>
implements Future<ReturnType> {
    private final Supplier<Future<InnerReturnType>> innerFutureSupplier;
    private final Supplier<ReturnType> returnTypeSupplier;
    private volatile Future<InnerReturnType> innerFuture;

    public WrappingLambdaFuture(Supplier<Future<InnerReturnType>> innerFutureSupplier, Supplier<ReturnType> returnTypeSupplier) {
        this.innerFutureSupplier = innerFutureSupplier;
        this.returnTypeSupplier = returnTypeSupplier;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.initialize();
        return this.innerFuture.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        this.initialize();
        return this.innerFuture != null && this.innerFuture.isCancelled();
    }

    @Override
    public boolean isDone() {
        this.initialize();
        return this.innerFuture != null && this.innerFuture.isDone();
    }

    @Override
    public ReturnType get() throws InterruptedException, ExecutionException {
        this.initialize();
        this.innerFuture.get();
        return this.returnTypeSupplier.get();
    }

    @Override
    public ReturnType get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        this.initialize();
        this.innerFuture.get(timeout, unit);
        return this.returnTypeSupplier.get();
    }

    private synchronized void initialize() {
        if (this.innerFuture == null) {
            this.innerFuture = this.innerFutureSupplier.get();
        }
    }
}

