/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.io;

import com.swirlds.common.AutoCloseableNonThrowing;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Function;

public interface IOIterator<T>
extends AutoCloseableNonThrowing {
    public boolean hasNext() throws IOException;

    public T next() throws IOException;

    default public T peek() throws IOException {
        throw new UnsupportedOperationException();
    }

    default public void forEachRemaining(Consumer<? super T> action) throws IOException {
        while (this.hasNext()) {
            action.accept(this.next());
        }
    }

    @Override
    default public void close() {
    }

    default public <U> IOIterator<U> transform(final Function<T, U> converter) {
        final IOIterator parentIterator = this;
        return new IOIterator<U>(this){
            private U next;

            @Override
            public boolean hasNext() throws IOException {
                if (this.next != null) {
                    return true;
                }
                if (!parentIterator.hasNext()) {
                    return false;
                }
                this.next = converter.apply(parentIterator.next());
                return true;
            }

            @Override
            public U peek() throws IOException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.next;
            }

            @Override
            public U next() throws IOException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                try {
                    Object u = this.next;
                    return u;
                }
                finally {
                    this.next = null;
                }
            }
        };
    }
}

