/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.io.extendable.extensions;

import com.swirlds.common.crypto.DigestType;
import com.swirlds.common.crypto.Hash;
import com.swirlds.common.io.extendable.extensions.AbstractStreamExtension;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;

public class HashingStreamExtension
extends AbstractStreamExtension {
    private final DigestType digestType;
    private final MessageDigest digest;
    private volatile boolean enabled;

    public HashingStreamExtension(DigestType digestType) {
        this.digestType = digestType;
        try {
            this.digest = MessageDigest.getInstance(digestType.algorithmName(), digestType.provider());
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
        this.enabled = false;
    }

    public void startHashing() {
        this.enabled = true;
    }

    public Hash finishHashing() {
        return new Hash(this.digest.digest(), this.digestType);
    }

    @Override
    public void newByte(int aByte) {
        if (this.enabled) {
            this.digest.update((byte)aByte);
        }
    }

    @Override
    public void newBytes(byte[] bytes, int offset, int length) {
        if (this.enabled) {
            this.digest.update(bytes, offset, length);
        }
    }
}

