/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.io.streams;

import com.swirlds.base.function.CheckedFunction;
import com.swirlds.common.constructable.ConstructableRegistry;
import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.io.SerializableDet;
import com.swirlds.common.io.exceptions.ClassNotFoundException;
import com.swirlds.common.io.exceptions.InvalidVersionException;
import com.swirlds.common.io.streams.AugmentedDataInputStream;
import com.swirlds.common.utility.ValueReference;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Supplier;

public class SerializableDataInputStream
extends AugmentedDataInputStream {
    private static final int PROTOCOL_VERSION = 1;

    public SerializableDataInputStream(InputStream in) {
        super(in);
    }

    public void readProtocolVersion() throws IOException {
        int protocolVersion = this.readInt();
        if (protocolVersion != 1) {
            throw new IOException("invalid protocol version " + protocolVersion);
        }
    }

    public <T extends SelfSerializable> T readSerializable() throws IOException {
        return this.readSerializable(true, SerializableDataInputStream::registryConstructor);
    }

    public <T extends SelfSerializable> T readSerializable(boolean readClassId, @NonNull Supplier<T> serializableConstructor) throws IOException {
        Objects.requireNonNull(serializableConstructor, "serializableConstructor must not be null");
        return this.readSerializable(readClassId, id -> (SelfSerializable)serializableConstructor.get());
    }

    protected void validateVersion(SerializableDet object, int version) throws InvalidVersionException {
        if (version < object.getMinimumSupportedVersion() || version > object.getVersion()) {
            throw new InvalidVersionException(version, object);
        }
    }

    protected void recordClassId(long classId) {
    }

    protected void recordClass(Object o) {
    }

    private <T extends SelfSerializable> T readSerializable(boolean readClassId, CheckedFunction<Long, T, IOException> serializableConstructor) throws IOException {
        int version;
        Long classId;
        if (readClassId) {
            classId = this.readLong();
            this.recordClassId(classId);
            if (classId == Long.MIN_VALUE) {
                return null;
            }
        } else {
            classId = null;
        }
        if ((version = this.readInt()) == Integer.MIN_VALUE) {
            return null;
        }
        SelfSerializable serializable = (SelfSerializable)serializableConstructor.apply((Object)classId);
        this.recordClass(serializable);
        this.validateVersion(serializable, version);
        serializable.deserialize(this, version);
        return (T)serializable;
    }

    public <T extends SelfSerializable> void readSerializableIterableWithSize(int maxSize, Consumer<T> callback) throws IOException {
        int size = this.readInt();
        this.checkLengthLimit(size, maxSize);
        this.readSerializableIterableWithSizeInternal(size, true, SerializableDataInputStream::registryConstructor, callback);
    }

    public <T extends SelfSerializable> void readSerializableIterableWithSize(int maxSize, boolean readClassId, Supplier<T> serializableConstructor, Consumer<T> callback) throws IOException {
        int size = this.readInt();
        this.checkLengthLimit(size, maxSize);
        this.readSerializableIterableWithSizeInternal(size, readClassId, id -> (SelfSerializable)serializableConstructor.get(), callback);
    }

    private <T extends SelfSerializable> void readSerializableIterableWithSizeInternal(int size, boolean readClassId, CheckedFunction<Long, T, IOException> serializableConstructor, Consumer<T> callback) throws IOException {
        if (serializableConstructor == null) {
            throw new IllegalArgumentException("serializableConstructor is null");
        }
        if (size == 0) {
            return;
        }
        boolean allSameClass = this.readBoolean();
        ValueReference<Long> classId = new ValueReference<Long>();
        ValueReference<Integer> version = new ValueReference<Integer>();
        for (int i = 0; i < size; ++i) {
            T next = this.readNextSerializableIteration(allSameClass, readClassId, classId, version, serializableConstructor);
            callback.accept(next);
        }
    }

    protected <T extends SelfSerializable> T readNextSerializableIteration(boolean allSameClass, boolean readClassId, ValueReference<Long> classId, ValueReference<Integer> version, CheckedFunction<Long, T, IOException> serializableConstructor) throws IOException {
        if (!allSameClass) {
            return this.readSerializable(readClassId, serializableConstructor);
        }
        boolean isNull = this.readBoolean();
        if (isNull) {
            return null;
        }
        if (version.getValue() == null) {
            if (readClassId) {
                classId.setValue(this.readLong());
            }
            version.setValue(this.readInt());
        }
        SelfSerializable serializable = (SelfSerializable)serializableConstructor.apply((Object)classId.getValue());
        this.recordClassId(serializable.getClassId());
        this.recordClass(serializable);
        serializable.deserialize(this, version.getValue());
        return (T)serializable;
    }

    public <T extends SelfSerializable> List<T> readSerializableList(int maxListSize) throws IOException {
        return this.readSerializableList(maxListSize, true, SerializableDataInputStream::registryConstructor);
    }

    public <T extends SelfSerializable> List<T> readSerializableList(int maxListSize, boolean readClassId, @NonNull Supplier<T> serializableConstructor) throws IOException {
        Objects.requireNonNull(serializableConstructor, "serializableConstructor must not be null");
        return this.readSerializableList(maxListSize, readClassId, id -> (SelfSerializable)serializableConstructor.get());
    }

    private <T extends SelfSerializable> List<T> readSerializableList(int maxListSize, boolean readClassId, CheckedFunction<Long, T, IOException> serializableConstructor) throws IOException {
        int length = this.readInt();
        if (length == -1) {
            return null;
        }
        this.checkLengthLimit(length, maxListSize);
        ArrayList list = new ArrayList(length);
        if (length == 0) {
            return list;
        }
        this.readSerializableIterableWithSizeInternal(length, readClassId, serializableConstructor, list::add);
        return list;
    }

    public <T extends SelfSerializable> T[] readSerializableArray(IntFunction<T[]> arrayConstructor, int maxListSize, boolean readClassId) throws IOException {
        List<SelfSerializable> list = this.readSerializableList(maxListSize, readClassId, SerializableDataInputStream::registryConstructor);
        if (list == null) {
            return null;
        }
        return list.toArray((SelfSerializable[])arrayConstructor.apply(list.size()));
    }

    public <T extends SelfSerializable> T[] readSerializableArray(IntFunction<T[]> arrayConstructor, int maxListSize, boolean readClassId, Supplier<T> serializableConstructor) throws IOException {
        List<SelfSerializable> list = this.readSerializableList(maxListSize, readClassId, id -> (SelfSerializable)serializableConstructor.get());
        if (list == null) {
            return null;
        }
        return list.toArray((SelfSerializable[])arrayConstructor.apply(list.size()));
    }

    private static <T extends SelfSerializable> T registryConstructor(long classId) throws IOException {
        SelfSerializable rc = (SelfSerializable)ConstructableRegistry.getInstance().createObject(classId);
        if (rc == null) {
            throw new ClassNotFoundException(classId);
        }
        return (T)rc;
    }
}

