/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.io.streams.internal;

import com.swirlds.common.io.streams.internal.SerializationOperation;
import java.util.Deque;
import java.util.LinkedList;

public class SerializationStackElement {
    public static final int MAX_CHILD_COUNT = 10;
    public static final int SECOND_TO_LAST_MAX_CHILD_COUNT = 5;
    private static final int MAX_STRING_REPRESENTATION_LENGTH = 30;
    private static final String INDENT = "   ";
    private final SerializationOperation operation;
    private final StackTraceElement callLocation;
    private Long classId;
    private Class<?> clazz;
    private String stringRepresentation;
    private final Deque<SerializationStackElement> children = new LinkedList<SerializationStackElement>();
    private SerializationStackElement secondToLastChild;
    private long currentChildCount;
    private long totalChildCount;

    public SerializationStackElement(SerializationOperation operation, StackTraceElement callLocation) {
        this.operation = operation;
        this.callLocation = callLocation;
    }

    public SerializationOperation getOperation() {
        return this.operation;
    }

    public void addChild(SerializationStackElement child) {
        SerializationStackElement newThirdToLastChild = this.secondToLastChild;
        if (newThirdToLastChild != null) {
            newThirdToLastChild.children.clear();
            newThirdToLastChild.currentChildCount = 0L;
        }
        if (this.currentChildCount > 0L) {
            SerializationStackElement newSecondToLastChild = this.children.getLast();
            newSecondToLastChild.reduceChildCount(5);
            if (newSecondToLastChild.secondToLastChild != null) {
                newSecondToLastChild.secondToLastChild.children.clear();
                newSecondToLastChild.secondToLastChild.currentChildCount = 0L;
            }
            this.secondToLastChild = newSecondToLastChild;
        }
        ++this.currentChildCount;
        ++this.totalChildCount;
        this.children.addLast(child);
        this.reduceChildCount(10);
    }

    public void setClassId(long classId) {
        this.classId = classId;
    }

    public void setClass(Class<?> clazz) {
        this.clazz = clazz;
    }

    public void setStringRepresentation(String stringRepresentation) {
        this.stringRepresentation = stringRepresentation.length() > 30 ? stringRepresentation.substring(0, 30) + "..." : stringRepresentation;
    }

    private void reduceChildCount(int maxChildCount) {
        while (this.currentChildCount > (long)maxChildCount) {
            this.children.removeFirst();
            --this.currentChildCount;
        }
    }

    public void writeStackTrace(StringBuilder sb, int indent) {
        sb.append(INDENT.repeat(indent));
        sb.append(this.operation.name());
        if (this.stringRepresentation != null) {
            sb.append(" [value=").append(this.stringRepresentation).append("]");
        }
        if (this.clazz != null) {
            sb.append(" ").append(this.clazz.getSimpleName());
        } else if (this.classId != null) {
            if (this.classId == Long.MIN_VALUE) {
                sb.append(" NULL");
            } else {
                sb.append(String.format(" class ID = %d(0x%08X)", this.classId, this.classId));
            }
        }
        sb.append(" @ ").append(this.callLocation.getFileName()).append(":").append(this.callLocation.getLineNumber());
        sb.append("\n");
        int childIndent = indent + 1;
        long undisplayed = this.totalChildCount - this.currentChildCount;
        if (undisplayed > 0L) {
            sb.append(INDENT.repeat(childIndent));
            sb.append("(").append(undisplayed).append(" hidden)\n");
        }
        for (SerializationStackElement child : this.children) {
            child.writeStackTrace(sb, childIndent);
        }
    }

    public StackTraceElement getCallLocation() {
        return this.callLocation;
    }

    public Long getClassId() {
        return this.classId;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public String getStringRepresentation() {
        return this.stringRepresentation;
    }

    public Deque<SerializationStackElement> getChildren() {
        return this.children;
    }

    public long getCurrentChildCount() {
        return this.currentChildCount;
    }

    public long getTotalChildCount() {
        return this.totalChildCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.writeStackTrace(sb, 0);
        return sb.toString();
    }
}

