/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.crypto;

import com.swirlds.common.crypto.Cryptography;
import com.swirlds.common.crypto.DigestType;
import com.swirlds.common.crypto.Hash;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.MerkleNode;
import java.util.List;
import java.util.concurrent.Future;

public interface MerkleCryptography {
    default public Hash digestSync(MerkleInternal node) {
        return this.digestSync(node, Cryptography.DEFAULT_DIGEST_TYPE);
    }

    default public Hash digestSync(MerkleInternal node, DigestType digestType) {
        return this.digestSync(node, digestType, true);
    }

    public Hash digestSync(MerkleInternal var1, DigestType var2, boolean var3);

    default public Hash digestSync(MerkleInternal node, List<Hash> childHashes) {
        return this.digestSync(node, childHashes, true);
    }

    public Hash digestSync(MerkleInternal var1, List<Hash> var2, boolean var3);

    public Hash digestSync(MerkleLeaf var1, DigestType var2);

    default public Hash digestSync(MerkleNode node, DigestType digestType) {
        if (node.isLeaf()) {
            return this.digestSync(node.asLeaf(), digestType);
        }
        return this.digestSync(node.asInternal(), digestType);
    }

    public Hash digestTreeSync(MerkleNode var1, DigestType var2);

    default public Hash digestTreeSync(MerkleNode root) {
        return this.digestTreeSync(root, Cryptography.DEFAULT_DIGEST_TYPE);
    }

    public Future<Hash> digestTreeAsync(MerkleNode var1, DigestType var2);

    default public Future<Hash> digestTreeAsync(MerkleNode root) {
        return this.digestTreeAsync(root, Cryptography.DEFAULT_DIGEST_TYPE);
    }
}

