/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.crypto.internal;

import com.swirlds.common.crypto.Cryptography;
import com.swirlds.common.crypto.CryptographyException;
import com.swirlds.common.crypto.DigestType;
import com.swirlds.common.crypto.Hash;
import com.swirlds.common.crypto.config.CryptoConfig;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.crypto.MerkleCryptography;
import com.swirlds.common.merkle.crypto.internal.MerkleInternalDigestProvider;
import com.swirlds.common.merkle.hash.MerkleHashBuilder;
import com.swirlds.common.merkle.utility.MerkleConstants;
import com.swirlds.common.threading.manager.ThreadManager;
import com.swirlds.logging.legacy.LogMarker;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;

public class MerkleCryptoEngine
implements MerkleCryptography {
    private final MerkleInternalDigestProvider merkleInternalDigestProvider;
    private final MerkleHashBuilder merkleHashBuilder;
    private final Cryptography basicCryptoEngine;

    public MerkleCryptoEngine(ThreadManager threadManager, Cryptography cryptography, CryptoConfig settings) {
        this.basicCryptoEngine = cryptography;
        this.merkleInternalDigestProvider = new MerkleInternalDigestProvider();
        this.merkleHashBuilder = new MerkleHashBuilder(threadManager, this, cryptography, settings.computeCpuDigestThreadCount());
    }

    @Override
    public Hash digestTreeSync(MerkleNode root, DigestType digestType) {
        return this.merkleHashBuilder.digestTreeSync(root);
    }

    @Override
    public Future<Hash> digestTreeAsync(MerkleNode root, DigestType digestType) {
        return this.merkleHashBuilder.digestTreeAsync(root);
    }

    @Override
    public Hash digestSync(MerkleInternal node, List<Hash> childHashes, boolean setHash) {
        try {
            Hash hash = this.merkleInternalDigestProvider.compute(node, childHashes, MerkleConstants.MERKLE_DIGEST_TYPE);
            if (setHash) {
                node.setHash(hash);
            }
            return hash;
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptographyException(e, LogMarker.EXCEPTION);
        }
    }

    @Override
    public Hash digestSync(MerkleInternal node, DigestType digestType, boolean setHash) {
        ArrayList<Hash> childHashes = new ArrayList<Hash>(node.getNumberOfChildren());
        for (int childIndex = 0; childIndex < node.getNumberOfChildren(); ++childIndex) {
            MerkleNode child = node.getChild(childIndex);
            if (child == null) {
                childHashes.add(this.basicCryptoEngine.getNullHash(digestType));
                continue;
            }
            childHashes.add(child.getHash());
        }
        return this.digestSync(node, childHashes, setHash);
    }

    @Override
    public Hash digestSync(MerkleLeaf leaf, DigestType digestType) {
        return this.basicCryptoEngine.digestSync(leaf, digestType);
    }
}

