/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics;

import com.swirlds.base.ArgumentUtils;
import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.MetricType;
import com.swirlds.common.metrics.PlatformMetricConfig;
import com.swirlds.common.metrics.PlatformMetricsFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.EnumSet;
import java.util.Objects;

public interface DurationGauge
extends Metric {
    @Override
    default public MetricType getMetricType() {
        return MetricType.GAUGE;
    }

    @Override
    default public Metric.DataType getDataType() {
        return Metric.DataType.FLOAT;
    }

    @Override
    default public EnumSet<Metric.ValueType> getValueTypes() {
        return EnumSet.of(Metric.ValueType.VALUE);
    }

    @Override
    default public Double get(@NonNull Metric.ValueType valueType) {
        Objects.requireNonNull(valueType, "valueType");
        if (valueType == Metric.ValueType.VALUE) {
            return this.get();
        }
        throw new IllegalArgumentException("Unsupported ValueType: " + String.valueOf((Object)valueType));
    }

    public long getNanos();

    public void set(Duration var1);

    public double get();

    public static final class Config
    extends PlatformMetricConfig<DurationGauge, Config> {
        private static final String TIME_UNIT = "timeUnit";
        private static final String UNSUPPORTED_TIME_UNIT = "Unsupported time unit: ";
        private final ChronoUnit timeUnit;

        public Config(@NonNull String category, @NonNull String name, ChronoUnit timeUnit) {
            super(category, Config.fixName(name, timeUnit), Config.getFormat(timeUnit));
            this.timeUnit = timeUnit;
        }

        private static String fixName(@NonNull String name, ChronoUnit timeUnit) {
            return ArgumentUtils.throwArgBlank((String)name, (String)"name") + " " + Config.getAppendix(timeUnit);
        }

        private Config(@NonNull String category, @NonNull String name, @NonNull String description, ChronoUnit timeUnit) {
            super(category, name, description, Config.getUnit(timeUnit), Config.getFormat(timeUnit));
            this.timeUnit = timeUnit;
        }

        @Override
        public Config withDescription(@NonNull String description) {
            return new Config(this.getCategory(), this.getName(), description, this.getTimeUnit());
        }

        @Override
        public Config withUnit(@NonNull String unit) {
            throw new UnsupportedOperationException("a String unit is not compatible with this class");
        }

        public ChronoUnit getTimeUnit() {
            return this.timeUnit;
        }

        @Override
        public Class<DurationGauge> getResultClass() {
            return DurationGauge.class;
        }

        @Override
        @NonNull
        public DurationGauge create(@NonNull PlatformMetricsFactory factory) {
            return factory.createDurationGauge(this);
        }

        @NonNull
        private static String getFormat(@NonNull ChronoUnit timeUnit) {
            Objects.requireNonNull(timeUnit, TIME_UNIT);
            return switch (timeUnit) {
                case ChronoUnit.NANOS, ChronoUnit.MICROS -> "%,.0f";
                case ChronoUnit.MILLIS, ChronoUnit.SECONDS -> "%,.3f";
                default -> throw new IllegalArgumentException(UNSUPPORTED_TIME_UNIT + String.valueOf(timeUnit));
            };
        }

        @NonNull
        private static String getUnit(ChronoUnit timeUnit) {
            Objects.requireNonNull(timeUnit, TIME_UNIT);
            return switch (timeUnit) {
                case ChronoUnit.NANOS -> "ns";
                case ChronoUnit.MICROS -> "\u00b5s";
                case ChronoUnit.MILLIS -> "ms";
                case ChronoUnit.SECONDS -> "s";
                default -> throw new IllegalArgumentException(UNSUPPORTED_TIME_UNIT + String.valueOf(timeUnit));
            };
        }

        @NonNull
        private static String getAppendix(ChronoUnit timeUnit) {
            Objects.requireNonNull(timeUnit, TIME_UNIT);
            return switch (timeUnit) {
                case ChronoUnit.NANOS -> "(nanos)";
                case ChronoUnit.MICROS -> "(micros)";
                case ChronoUnit.MILLIS -> "(millis)";
                case ChronoUnit.SECONDS -> "(sec)";
                default -> throw new IllegalArgumentException(UNSUPPORTED_TIME_UNIT + String.valueOf(timeUnit));
            };
        }
    }
}

