/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.MetricType;
import com.swirlds.common.metrics.PlatformMetricConfig;
import com.swirlds.common.metrics.PlatformMetricsFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.Supplier;

public interface FunctionGauge<T>
extends Metric {
    @Override
    default public MetricType getMetricType() {
        return MetricType.GAUGE;
    }

    @Override
    default public EnumSet<Metric.ValueType> getValueTypes() {
        return EnumSet.of(Metric.ValueType.VALUE);
    }

    default public T get(Metric.ValueType valueType) {
        Objects.requireNonNull(valueType, "valueType");
        if (valueType == Metric.ValueType.VALUE) {
            return this.get();
        }
        throw new IllegalArgumentException("Unsupported ValueType: " + String.valueOf((Object)valueType));
    }

    public T get();

    public static final class Config<T>
    extends PlatformMetricConfig<FunctionGauge<T>, Config<T>> {
        private final Class<T> type;
        private final Supplier<T> supplier;

        public Config(@NonNull String category, @NonNull String name, @NonNull Class<T> type, @NonNull Supplier<T> supplier) {
            super(category, name, "%s");
            this.type = Objects.requireNonNull(type, "type");
            this.supplier = Objects.requireNonNull(supplier, "supplier");
        }

        private Config(@NonNull String category, @NonNull String name, @NonNull String description, @NonNull String unit, @NonNull String format, @NonNull Class<T> type, @NonNull Supplier<T> supplier) {
            super(category, name, description, unit, format);
            this.type = Objects.requireNonNull(type, "type");
            this.supplier = Objects.requireNonNull(supplier, "supplier");
        }

        @Override
        public Config<T> withDescription(@NonNull String description) {
            return new Config<T>(this.getCategory(), this.getName(), description, this.getUnit(), this.getFormat(), this.getType(), this.getSupplier());
        }

        @Override
        public Config<T> withUnit(@NonNull String unit) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), unit, this.getFormat(), this.getType(), this.getSupplier());
        }

        @NonNull
        public Config<T> withFormat(@NonNull String format) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), format, this.getType(), this.getSupplier());
        }

        @NonNull
        public Class<T> getType() {
            return this.type;
        }

        @NonNull
        public Supplier<T> getSupplier() {
            return this.supplier;
        }

        @Override
        public Class<FunctionGauge<T>> getResultClass() {
            return FunctionGauge.class;
        }

        @Override
        @NonNull
        public FunctionGauge<T> create(@NonNull PlatformMetricsFactory factory) {
            return factory.createFunctionGauge(this);
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("type", (Object)this.type.getName()).toString();
        }
    }
}

