/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.MetricConfig;
import com.swirlds.common.metrics.MetricType;
import com.swirlds.common.metrics.MetricsFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.LongBinaryOperator;
import java.util.function.LongSupplier;

public interface LongAccumulator
extends Metric {
    @Override
    default public MetricType getMetricType() {
        return MetricType.ACCUMULATOR;
    }

    @Override
    default public Metric.DataType getDataType() {
        return Metric.DataType.INT;
    }

    @Override
    default public EnumSet<Metric.ValueType> getValueTypes() {
        return EnumSet.of(Metric.ValueType.VALUE);
    }

    @Override
    default public Long get(Metric.ValueType valueType) {
        Objects.requireNonNull(valueType, "valueType");
        if (valueType == Metric.ValueType.VALUE) {
            return this.get();
        }
        throw new IllegalArgumentException("Unsupported ValueType: " + String.valueOf((Object)valueType));
    }

    public long get();

    public long getInitialValue();

    public void update(long var1);

    public static final class Config
    extends MetricConfig<LongAccumulator, Config> {
        private final LongBinaryOperator accumulator;
        private final LongSupplier initializer;
        private final long initialValue;

        public Config(@NonNull String category, @NonNull String name) {
            super(category, name, "%d");
            this.accumulator = Long::max;
            this.initializer = null;
            this.initialValue = 0L;
        }

        private Config(@NonNull String category, @NonNull String name, @NonNull String description, @NonNull String unit, @NonNull String format, @NonNull LongBinaryOperator accumulator, @Nullable LongSupplier initializer, long initialValue) {
            super(category, name, description, unit, format);
            this.accumulator = Objects.requireNonNull(accumulator, "accumulator");
            this.initializer = initializer;
            this.initialValue = initialValue;
        }

        @Override
        public Config withDescription(@NonNull String description) {
            return new Config(this.getCategory(), this.getName(), description, this.getUnit(), this.getFormat(), this.getAccumulator(), this.getInitializer(), this.getInitialValue());
        }

        @Override
        public Config withUnit(@NonNull String unit) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), unit, this.getFormat(), this.getAccumulator(), this.getInitializer(), this.getInitialValue());
        }

        @NonNull
        public Config withFormat(@NonNull String format) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), format, this.getAccumulator(), this.getInitializer(), this.getInitialValue());
        }

        @NonNull
        public LongBinaryOperator getAccumulator() {
            return this.accumulator;
        }

        @Nullable
        public LongSupplier getInitializer() {
            return this.initializer;
        }

        @NonNull
        public Config withAccumulator(@NonNull LongBinaryOperator accumulator) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), accumulator, this.getInitializer(), this.getInitialValue());
        }

        @NonNull
        public Config withInitializer(@NonNull LongSupplier initializer) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), this.getAccumulator(), Objects.requireNonNull(initializer, "initializer"), this.getInitialValue());
        }

        public long getInitialValue() {
            return this.initialValue;
        }

        @NonNull
        public Config withInitialValue(long initialValue) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), this.getAccumulator(), this.getInitializer(), initialValue);
        }

        @Override
        public Class<LongAccumulator> getResultClass() {
            return LongAccumulator.class;
        }

        @Override
        @NonNull
        public LongAccumulator create(@NonNull MetricsFactory factory) {
            return factory.createLongAccumulator(this);
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("initialValue", (Object)this.initialValue).toString();
        }
    }
}

