/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.MetricType;
import com.swirlds.common.metrics.PlatformMetricConfig;
import com.swirlds.common.metrics.PlatformMetricsFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.EnumSet;

public interface SpeedometerMetric
extends Metric {
    @Override
    default public MetricType getMetricType() {
        return MetricType.SPEEDOMETER;
    }

    @Override
    default public Metric.DataType getDataType() {
        return Metric.DataType.FLOAT;
    }

    @Override
    default public EnumSet<Metric.ValueType> getValueTypes() {
        return EnumSet.of(Metric.ValueType.VALUE, Metric.ValueType.MAX, Metric.ValueType.MIN, Metric.ValueType.STD_DEV);
    }

    @Override
    public Double get(Metric.ValueType var1);

    public double getHalfLife();

    public void update(double var1);

    public void cycle();

    public double get();

    public static final class Config
    extends PlatformMetricConfig<SpeedometerMetric, Config> {
        private final double halfLife;
        private final boolean useDefaultHalfLife;

        public Config(@NonNull String category, @NonNull String name) {
            super(category, name, "%,11.3f");
            this.halfLife = -1.0;
            this.useDefaultHalfLife = true;
        }

        private Config(@NonNull String category, @NonNull String name, @NonNull String description, @NonNull String unit, @NonNull String format, double halfLife, boolean useDefaultHalfLife) {
            super(category, name, description, unit, format);
            this.halfLife = halfLife;
            this.useDefaultHalfLife = useDefaultHalfLife;
        }

        @Override
        public Config withDescription(@NonNull String description) {
            return new Config(this.getCategory(), this.getName(), description, this.getUnit(), this.getFormat(), this.getHalfLife(), this.isUseDefaultHalfLife());
        }

        @Override
        public Config withUnit(@NonNull String unit) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), unit, this.getFormat(), this.getHalfLife(), this.isUseDefaultHalfLife());
        }

        @NonNull
        public Config withFormat(@NonNull String format) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), format, this.getHalfLife(), this.isUseDefaultHalfLife());
        }

        public double getHalfLife() {
            return this.halfLife;
        }

        public boolean isUseDefaultHalfLife() {
            return this.useDefaultHalfLife;
        }

        @NonNull
        public Config withHalfLife(double halfLife) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), halfLife, false);
        }

        @Override
        public Class<SpeedometerMetric> getResultClass() {
            return SpeedometerMetric.class;
        }

        @Override
        @NonNull
        public SpeedometerMetric create(@NonNull PlatformMetricsFactory factory) {
            return factory.createSpeedometerMetric(this);
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("halfLife", (Object)this.halfLife).toString();
        }
    }
}

