/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.common.metrics.IntegerAccumulator;
import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.platform.DefaultMetric;
import com.swirlds.common.metrics.platform.Snapshot;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntBinaryOperator;
import java.util.function.IntSupplier;

public class DefaultIntegerAccumulator
extends DefaultMetric
implements IntegerAccumulator {
    private final AtomicInteger container;
    private final IntBinaryOperator accumulator;
    private final IntSupplier initializer;

    public DefaultIntegerAccumulator(IntegerAccumulator.Config config) {
        super(config);
        this.accumulator = config.getAccumulator();
        int initialValue = config.getInitialValue();
        this.initializer = config.getInitializer() != null ? config.getInitializer() : () -> initialValue;
        this.container = new AtomicInteger(this.initializer.getAsInt());
    }

    @Override
    public int getInitialValue() {
        return this.initializer.getAsInt();
    }

    @Override
    public List<Snapshot.SnapshotEntry> takeSnapshot() {
        return List.of(new Snapshot.SnapshotEntry(Metric.ValueType.VALUE, this.container.getAndSet(this.initializer.getAsInt())));
    }

    @Override
    public int get() {
        return this.container.get();
    }

    @Override
    public void update(int other) {
        this.container.accumulateAndGet(other, this.accumulator);
    }

    @Override
    public void reset() {
        this.container.set(this.initializer.getAsInt());
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("value", (Object)this.get()).toString();
    }
}

