/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform.prometheus;

import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.platform.Snapshot;
import com.swirlds.common.metrics.platform.prometheus.AbstractMetricAdapter;
import com.swirlds.common.metrics.platform.prometheus.NameConverter;
import com.swirlds.common.metrics.platform.prometheus.PrometheusEndpoint;
import com.swirlds.common.platform.NodeId;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Gauge;
import java.util.Objects;

public class NumberAdapter
extends AbstractMetricAdapter {
    private final Gauge gauge;

    public NumberAdapter(CollectorRegistry registry, Metric metric, PrometheusEndpoint.AdapterType adapterType) {
        super(adapterType);
        Objects.requireNonNull(registry, "registry must not be null");
        Objects.requireNonNull(metric, "metric must not be null");
        Gauge.Builder builder = (Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)new Gauge.Builder().subsystem(NameConverter.fix(metric.getCategory()))).name(NameConverter.fix(metric.getName()))).help(metric.getDescription())).unit(metric.getUnit());
        if (adapterType == PrometheusEndpoint.AdapterType.PLATFORM) {
            builder.labelNames(new String[]{"node"});
        }
        this.gauge = (Gauge)builder.register(registry);
    }

    @Override
    public void update(Snapshot snapshot, NodeId nodeId) {
        Objects.requireNonNull(snapshot, "snapshot must not be null");
        double newValue = ((Number)snapshot.getValue()).doubleValue();
        if (this.adapterType == PrometheusEndpoint.AdapterType.GLOBAL) {
            this.gauge.set(newValue);
        } else {
            Objects.requireNonNull(nodeId, "nodeId must not be null");
            Gauge.Child child = (Gauge.Child)this.gauge.labels(new String[]{nodeId.toString()});
            child.set(newValue);
        }
    }

    @Override
    public void unregister(CollectorRegistry registry) {
        registry.unregister((Collector)this.gauge);
    }
}

