/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform.prometheus;

import com.sun.net.httpserver.HttpServer;
import com.swirlds.common.AutoCloseableNonThrowing;
import com.swirlds.common.metrics.Counter;
import com.swirlds.common.metrics.FunctionGauge;
import com.swirlds.common.metrics.IntegerPairAccumulator;
import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.RunningAverageMetric;
import com.swirlds.common.metrics.SpeedometerMetric;
import com.swirlds.common.metrics.StatEntry;
import com.swirlds.common.metrics.platform.DefaultMetrics;
import com.swirlds.common.metrics.platform.MetricsEvent;
import com.swirlds.common.metrics.platform.Snapshot;
import com.swirlds.common.metrics.platform.SnapshotEvent;
import com.swirlds.common.metrics.platform.prometheus.BooleanAdapter;
import com.swirlds.common.metrics.platform.prometheus.CounterAdapter;
import com.swirlds.common.metrics.platform.prometheus.DistributionAdapter;
import com.swirlds.common.metrics.platform.prometheus.MetricAdapter;
import com.swirlds.common.metrics.platform.prometheus.NumberAdapter;
import com.swirlds.common.metrics.platform.prometheus.StringAdapter;
import com.swirlds.common.platform.NodeId;
import com.swirlds.common.utility.ThresholdLimitingHandler;
import com.swirlds.logging.legacy.LogMarker;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.HTTPServer;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PrometheusEndpoint
implements AutoCloseableNonThrowing {
    private static final Logger logger = LogManager.getLogger(PrometheusEndpoint.class);
    public static final String NODE_LABEL = "node";
    public static final String TYPE_LABEL = "type";
    private static final String TIME_METRIC_KEY = DefaultMetrics.calculateMetricKey("platform.info", "time");
    private final CollectorRegistry registry;
    private final Map<String, MetricAdapter> adapters = new ConcurrentHashMap<String, MetricAdapter>();
    private final HTTPServer httpServer;
    private final ThresholdLimitingHandler<Throwable> exceptionRateLimiter = new ThresholdLimitingHandler(10L);

    public PrometheusEndpoint(HttpServer httpServer) throws IOException {
        this(httpServer, new CollectorRegistry(false));
    }

    @Deprecated(forRemoval=true)
    public PrometheusEndpoint(HttpServer httpServer, CollectorRegistry registry) throws IOException {
        Objects.requireNonNull(httpServer, "httpServer must not be null");
        this.registry = Objects.requireNonNull(registry, "registry must not be null");
        logger.info(LogMarker.STARTUP.getMarker(), "PrometheusEndpoint: Starting server listing on port: {}", (Object)httpServer.getAddress().getPort());
        this.httpServer = new HTTPServer.Builder().withHttpServer(httpServer).withRegistry(registry).build();
    }

    public void handleMetricsChange(MetricsEvent notification) {
        Objects.requireNonNull(notification, "notification must not be null");
        Metric metric = notification.metric();
        String metricKey = DefaultMetrics.calculateMetricKey(metric);
        if (TIME_METRIC_KEY.equals(metricKey)) {
            return;
        }
        if (notification.type() == MetricsEvent.Type.ADDED) {
            this.adapters.computeIfAbsent(metricKey, key -> this.doCreate(notification.nodeId(), metric)).incAndGetReferenceCount();
        } else {
            MetricAdapter adapter = this.adapters.get(metricKey);
            if (adapter != null && adapter.decAndGetReferenceCount() == 0) {
                adapter.unregister(this.registry);
                this.adapters.remove(metricKey);
            }
        }
    }

    public void handleSnapshots(SnapshotEvent notification) {
        Objects.requireNonNull(notification, "notification must not be null");
        for (Snapshot snapshot : notification.snapshots()) {
            String metricKey = DefaultMetrics.calculateMetricKey(snapshot.metric());
            MetricAdapter adapter = this.adapters.get(metricKey);
            if (adapter == null) continue;
            try {
                adapter.update(snapshot, notification.nodeId());
            }
            catch (RuntimeException ex) {
                this.exceptionRateLimiter.handle(ex, error -> logger.error(LogMarker.EXCEPTION.getMarker(), "Exception while trying to update Prometheus endpoint with snapshot {}", (Object)snapshot, (Object)ex));
            }
        }
    }

    private MetricAdapter doCreate(NodeId nodeId, Metric metric) {
        AdapterType adapterType;
        AdapterType adapterType2 = adapterType = nodeId == null ? AdapterType.GLOBAL : AdapterType.PLATFORM;
        if (metric instanceof Counter) {
            return new CounterAdapter(this.registry, metric, adapterType);
        }
        if (metric instanceof RunningAverageMetric || metric instanceof SpeedometerMetric) {
            return new DistributionAdapter(this.registry, metric, adapterType);
        }
        if (metric instanceof IntegerPairAccumulator || metric instanceof FunctionGauge || metric instanceof StatEntry) {
            return switch (metric.getDataType()) {
                case Metric.DataType.STRING -> new StringAdapter(this.registry, metric, adapterType);
                case Metric.DataType.BOOLEAN -> new BooleanAdapter(this.registry, metric, adapterType);
                default -> new NumberAdapter(this.registry, metric, adapterType);
            };
        }
        return new NumberAdapter(this.registry, metric, adapterType);
    }

    @Override
    public void close() {
        this.httpServer.close();
    }

    public static enum AdapterType {
        GLOBAL,
        PLATFORM;

    }
}

