/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform.prometheus;

import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.platform.Snapshot;
import com.swirlds.common.metrics.platform.prometheus.AbstractMetricAdapter;
import com.swirlds.common.metrics.platform.prometheus.NameConverter;
import com.swirlds.common.metrics.platform.prometheus.PrometheusEndpoint;
import com.swirlds.common.platform.NodeId;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Info;
import java.util.Objects;

public class StringAdapter
extends AbstractMetricAdapter {
    private final Info info;

    public StringAdapter(CollectorRegistry registry, Metric metric, PrometheusEndpoint.AdapterType adapterType) {
        super(adapterType);
        Objects.requireNonNull(registry, "registry must not be null");
        Objects.requireNonNull(metric, "metric must not be null");
        Info.Builder builder = (Info.Builder)((Info.Builder)((Info.Builder)new Info.Builder().subsystem(NameConverter.fix(metric.getCategory()))).name(NameConverter.fix(metric.getName()))).help(metric.getDescription());
        if (adapterType == PrometheusEndpoint.AdapterType.PLATFORM) {
            builder.labelNames(new String[]{"node"});
        }
        this.info = (Info)builder.register(registry);
    }

    @Override
    public void update(Snapshot snapshot, NodeId nodeId) {
        Objects.requireNonNull(snapshot, "snapshot must not be null");
        String newValue = Objects.toString(snapshot.getValue());
        if (this.adapterType == PrometheusEndpoint.AdapterType.GLOBAL) {
            this.info.info(new String[]{"value", newValue});
        } else {
            Objects.requireNonNull(nodeId, "nodeId must not be null");
            Info.Child child = (Info.Child)this.info.labels(new String[]{nodeId.toString()});
            child.info(new String[]{"value", newValue});
        }
    }

    @Override
    public void unregister(CollectorRegistry registry) {
        registry.unregister((Collector)this.info);
    }
}

