/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.notification.internal;

import com.swirlds.common.notification.DispatchMode;
import com.swirlds.common.notification.DispatchModel;
import com.swirlds.common.notification.DispatchOrder;
import com.swirlds.common.notification.Listener;
import com.swirlds.common.notification.Notification;
import com.swirlds.common.notification.NotificationEngine;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractNotificationEngine
implements NotificationEngine {
    private Map<Class<? extends Listener>, DispatchMode> listenerModeCache = new HashMap<Class<? extends Listener>, DispatchMode>();
    private Map<Class<? extends Listener>, DispatchOrder> listenerOrderCache = new HashMap<Class<? extends Listener>, DispatchOrder>();
    private AtomicLong sequence = new AtomicLong(0L);

    protected synchronized <L extends Listener> DispatchMode dispatchMode(Class<L> listenerClass) {
        if (this.listenerModeCache.containsKey(listenerClass)) {
            return this.listenerModeCache.get(listenerClass);
        }
        DispatchModel model = listenerClass.getAnnotation(DispatchModel.class);
        DispatchMode mode = DispatchMode.SYNC;
        if (model != null) {
            mode = model.mode();
        }
        this.listenerModeCache.putIfAbsent(listenerClass, mode);
        return mode;
    }

    protected synchronized <L extends Listener> DispatchOrder dispatchOrder(Class<L> listenerClass) {
        if (this.listenerOrderCache.containsKey(listenerClass)) {
            return this.listenerOrderCache.get(listenerClass);
        }
        DispatchModel model = listenerClass.getAnnotation(DispatchModel.class);
        DispatchOrder order = DispatchOrder.UNORDERED;
        if (model != null) {
            order = model.order();
        }
        this.listenerOrderCache.putIfAbsent(listenerClass, order);
        return order;
    }

    protected <N extends Notification> void assignSequence(N notification) {
        if (notification == null) {
            throw new IllegalArgumentException("notification");
        }
        if (notification.getSequence() != 0L) {
            return;
        }
        notification.setSequence(this.sequence.incrementAndGet());
    }
}

