/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.sequence.set;

import com.swirlds.common.sequence.map.ConcurrentSequenceMap;
import com.swirlds.common.sequence.map.SequenceMap;
import com.swirlds.common.sequence.set.internal.AbstractSequenceSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.function.ToLongFunction;

public class ConcurrentSequenceSet<T>
extends AbstractSequenceSet<T> {
    public ConcurrentSequenceSet(long lowestAllowedSequenceNumber, int sequenceNumberCapacity, @NonNull ToLongFunction<T> getSequenceNumberFromEntry) {
        this(lowestAllowedSequenceNumber, sequenceNumberCapacity, false, getSequenceNumberFromEntry);
    }

    public ConcurrentSequenceSet(long lowestAllowedSequenceNumber, int sequenceNumberCapacity, boolean allowExpansion, @NonNull ToLongFunction<T> getSequenceNumberFromEntry) {
        super(lowestAllowedSequenceNumber, sequenceNumberCapacity, allowExpansion, getSequenceNumberFromEntry);
    }

    @Override
    @NonNull
    protected SequenceMap<T, Boolean> buildMap(long lowestAllowedSequenceNumber, int sequenceNumberCapacity, boolean allowExpansion, @NonNull ToLongFunction<T> getSequenceNumberFromEntry) {
        Objects.requireNonNull(getSequenceNumberFromEntry);
        return new ConcurrentSequenceMap(lowestAllowedSequenceNumber, sequenceNumberCapacity, allowExpansion, getSequenceNumberFromEntry);
    }
}

