/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.stream.internal;

import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.io.streams.SerializableDataInputStream;
import com.swirlds.common.stream.StreamType;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.logging.legacy.payload.StreamParseErrorPayload;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.util.Supplier;

public class SingleStreamIterator<T extends SelfSerializable>
implements Iterator<T> {
    private static final Logger logger = LogManager.getLogger(SingleStreamIterator.class);
    private static final Marker LOGM_OBJECT_STREAM = LogMarker.OBJECT_STREAM.getMarker();
    private static final Marker LOGM_EXCEPTION = LogMarker.EXCEPTION.getMarker();
    private SerializableDataInputStream stream;
    private boolean streamClosed;

    public SingleStreamIterator(File file, StreamType streamType) {
        try {
            this.stream = new SerializableDataInputStream(new BufferedInputStream(new FileInputStream(file)));
            logger.info(LOGM_OBJECT_STREAM, "SingleStreamIterator :: reading file: {}", new Supplier[]{() -> file.getName()});
            for (int i = 0; i < streamType.getFileHeader().length; ++i) {
                this.stream.readInt();
            }
            int objectStreamVersion = this.stream.readInt();
            logger.info(LOGM_OBJECT_STREAM, "SingleStreamIterator :: read OBJECT_STREAM_VERSION: {}", new Supplier[]{() -> objectStreamVersion});
        }
        catch (IOException | IllegalArgumentException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "SingleStreamIterator :: got Exception when parse File {}", (Object)file.getName(), (Object)e);
            this.closeStream();
        }
    }

    public SingleStreamIterator(InputStream inputStream) {
        this.stream = new SerializableDataInputStream(new BufferedInputStream(inputStream));
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.streamClosed) {
                return false;
            }
            if (this.stream.available() == 0) {
                this.closeStream();
                return false;
            }
            return true;
        }
        catch (IOException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), () -> new StreamParseErrorPayload("parseStream :: got IOException when readSerializable. "), (Throwable)e);
            this.closeStream();
            return false;
        }
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            return this.stream.readSerializable();
        }
        catch (IOException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), () -> new StreamParseErrorPayload("parseStream :: got IOException when readSerializable. "), (Throwable)e);
            this.closeStream();
            return null;
        }
    }

    public void closeStream() {
        try {
            if (this.stream != null) {
                this.stream.close();
            }
        }
        catch (IOException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "SingleStreamIterator :: got IOException when closing stream. ", (Throwable)e);
        }
        this.streamClosed = true;
    }
}

