/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading;

import com.swirlds.common.threading.locks.internal.AcquiredResource;
import com.swirlds.common.threading.locks.locked.LockedResource;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class BlockingResourceProvider<T> {
    private final Semaphore providePermit = new Semaphore(1);
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition resourceProvided = this.lock.newCondition();
    private final Condition resourceReleased = this.lock.newCondition();
    private final AtomicBoolean waitingForResource = new AtomicBoolean(false);
    private final LockedResource<T> resource = new AcquiredResource<Object>(this::consumerDone, null);

    public boolean acquireProvidePermit() {
        if (!this.waitingForResource.get()) {
            return false;
        }
        return this.providePermit.tryAcquire();
    }

    public boolean tryBlockProvidePermit() {
        return this.providePermit.tryAcquire();
    }

    public void releaseProvidePermit() {
        this.providePermit.release();
    }

    public void provide(T resource) throws InterruptedException {
        this.lock.lock();
        try {
            this.resource.setResource(resource);
            this.resourceProvided.signalAll();
            while (this.resource.getResource() != null) {
                this.resourceReleased.await();
            }
        }
        finally {
            this.lock.unlock();
            this.providePermit.release();
        }
    }

    public LockedResource<T> waitForResource() throws InterruptedException {
        this.lock.lock();
        this.waitingForResource.set(true);
        try {
            while (this.resource.getResource() == null) {
                this.resourceProvided.await();
            }
            LockedResource<T> lockedResource = this.resource;
            return lockedResource;
        }
        finally {
            this.waitingForResource.set(false);
        }
    }

    private void consumerDone() {
        this.resource.setResource(null);
        this.resourceReleased.signalAll();
        this.lock.unlock();
    }
}

