/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading.framework.internal;

import com.swirlds.common.threading.framework.QueueThread;
import com.swirlds.common.threading.framework.Stoppable;
import com.swirlds.common.threading.framework.config.QueueThreadMetricsConfiguration;
import com.swirlds.common.threading.framework.internal.AbstractStoppableThreadConfiguration;
import com.swirlds.common.threading.framework.internal.QueueThreadImpl;
import com.swirlds.common.threading.interrupt.InterruptableConsumer;
import com.swirlds.common.threading.interrupt.InterruptableRunnable;
import com.swirlds.common.threading.manager.ThreadManager;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;

public abstract class AbstractQueueThreadConfiguration<C extends AbstractQueueThreadConfiguration<C, T>, T>
extends AbstractStoppableThreadConfiguration<C, InterruptableRunnable> {
    public static final int DEFAULT_CAPACITY = 100;
    public static final int DEFAULT_MAX_BUFFER_SIZE = 10000;
    public static final int UNLIMITED_CAPACITY = -1;
    private int capacity = 100;
    private int maxBufferSize = 10000;
    private InterruptableConsumer<T> handler;
    private BlockingQueue<T> queue;
    private QueueThreadMetricsConfiguration metricsConfiguration;
    private InterruptableRunnable idleCallback;
    private InterruptableRunnable batchHandledCallback;
    private Duration waitForWorkDuration = Duration.ofMillis(10L);

    protected AbstractQueueThreadConfiguration(ThreadManager threadManager) {
        super(threadManager);
        this.setStopBehavior(Stoppable.StopBehavior.BLOCKING);
    }

    protected AbstractQueueThreadConfiguration(AbstractQueueThreadConfiguration<C, T> that) {
        super(that);
        this.capacity = that.capacity;
        this.maxBufferSize = that.maxBufferSize;
        this.handler = that.handler;
        this.queue = that.queue;
        this.metricsConfiguration = that.metricsConfiguration;
    }

    @Override
    public abstract AbstractQueueThreadConfiguration<C, T> copy();

    protected QueueThread<T> buildQueueThread(boolean start) {
        QueueThreadImpl thread = new QueueThreadImpl(this);
        if (start) {
            thread.start();
        }
        return thread;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public C setCapacity(int capacity) {
        this.throwIfImmutable();
        this.capacity = capacity;
        return (C)this;
    }

    public C setUnlimitedCapacity() {
        this.throwIfImmutable();
        this.capacity = -1;
        return (C)this;
    }

    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public C setMaxBufferSize(int maxBufferSize) {
        this.throwIfImmutable();
        this.maxBufferSize = maxBufferSize;
        return (C)this;
    }

    protected InterruptableConsumer<T> getHandler() {
        return this.handler;
    }

    protected C setHandler(InterruptableConsumer<T> handler) {
        this.throwIfImmutable();
        this.handler = handler;
        return (C)this;
    }

    public C setIdleCallback(@Nullable InterruptableRunnable idleCallback) {
        this.idleCallback = idleCallback;
        return (C)this;
    }

    @Nullable
    public InterruptableRunnable getIdleCallback() {
        return this.idleCallback;
    }

    @Nullable
    public InterruptableRunnable getBatchHandledCallback() {
        return this.batchHandledCallback;
    }

    public C setBatchHandledCallback(@Nullable InterruptableRunnable batchHandledCallback) {
        this.batchHandledCallback = batchHandledCallback;
        return (C)this;
    }

    @NonNull
    public Duration getWaitForWorkDuration() {
        return this.waitForWorkDuration;
    }

    public C setWaitForWorkDuration(@NonNull Duration waitForWorkDuration) {
        this.waitForWorkDuration = Objects.requireNonNull(waitForWorkDuration);
        return (C)this;
    }

    public BlockingQueue<T> getQueue() {
        return this.queue;
    }

    public C setQueue(BlockingQueue<T> queue) {
        this.throwIfImmutable();
        this.queue = queue;
        return (C)this;
    }

    public QueueThreadMetricsConfiguration getMetricsConfiguration() {
        return this.metricsConfiguration;
    }

    public C setMetricsConfiguration(QueueThreadMetricsConfiguration metricsConfiguration) {
        this.metricsConfiguration = metricsConfiguration;
        return (C)this;
    }
}

