/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading.framework.internal;

import com.swirlds.common.threading.framework.BlockingQueueInserter;
import com.swirlds.common.threading.framework.MultiQueueThread;
import com.swirlds.common.threading.framework.QueueThread;
import com.swirlds.common.threading.framework.Stoppable;
import com.swirlds.common.threading.framework.StoppableThread;
import com.swirlds.common.threading.framework.ThreadSeed;
import com.swirlds.common.threading.interrupt.InterruptableConsumer;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;

public class MultiQueueThreadImpl
implements MultiQueueThread {
    private final QueueThread<Object> queueThread;
    private final Map<Class<?>, Consumer<Object>> subHandlers;
    private final BlockingQueueInserter<Object> blockingQueueInserter;

    public MultiQueueThreadImpl(Map<Class<?>, Consumer<Object>> subHandlers, Function<InterruptableConsumer<Object>, QueueThread<Object>> queueThreadBuilder) {
        this.subHandlers = Objects.requireNonNull(subHandlers);
        this.queueThread = queueThreadBuilder.apply(this::handle);
        this.blockingQueueInserter = this.buildQueueInserter();
    }

    @Override
    public <T> BlockingQueueInserter<T> getInserter(Class<T> clazz) {
        Objects.requireNonNull(clazz, "null classes not supported");
        if (!this.subHandlers.containsKey(clazz)) {
            throw new IllegalStateException("no handler for " + String.valueOf(clazz));
        }
        return this.blockingQueueInserter;
    }

    private void handle(Object object) {
        Objects.requireNonNull(object, "null objects not supported");
        Class<?> clazz = object.getClass();
        Consumer<Object> handler = this.subHandlers.get(clazz);
        if (handler == null) {
            throw new IllegalStateException("no handler for " + String.valueOf(clazz));
        }
        handler.accept(object);
    }

    private BlockingQueueInserter<Object> buildQueueInserter() {
        return new BlockingQueueInserter<Object>(){

            @Override
            public boolean add(Object o) {
                return MultiQueueThreadImpl.this.queueThread.add(o);
            }

            @Override
            public boolean offer(Object o) {
                return MultiQueueThreadImpl.this.queueThread.offer(o);
            }

            @Override
            public boolean offer(Object o, long timeout, TimeUnit unit) throws InterruptedException {
                return MultiQueueThreadImpl.this.queueThread.offer(o, timeout, unit);
            }

            @Override
            public void put(Object o) throws InterruptedException {
                MultiQueueThreadImpl.this.queueThread.put(o);
            }
        };
    }

    @Override
    public void start() {
        this.queueThread.start();
    }

    @Override
    public boolean stop() {
        return this.queueThread.stop();
    }

    @Override
    public boolean stop(Stoppable.StopBehavior behavior) {
        return this.queueThread.stop(behavior);
    }

    @Override
    public boolean pause() {
        return this.queueThread.pause();
    }

    @Override
    public boolean resume() {
        return this.queueThread.resume();
    }

    @Override
    public void join() throws InterruptedException {
        this.queueThread.join();
    }

    @Override
    public void join(long millis) throws InterruptedException {
        this.queueThread.join(millis);
    }

    @Override
    public void join(long millis, int nanos) throws InterruptedException {
        this.queueThread.join(millis, nanos);
    }

    @Override
    public String getName() {
        return this.queueThread.getName();
    }

    @Override
    public ThreadSeed buildSeed() {
        return this.queueThread.buildSeed();
    }

    @Override
    public boolean interrupt() {
        return this.queueThread.interrupt();
    }

    @Override
    public boolean isAlive() {
        return this.queueThread.isAlive();
    }

    @Override
    public StoppableThread.Status getStatus() {
        return this.queueThread.getStatus();
    }

    @Override
    public boolean isHanging() {
        return this.queueThread.isHanging();
    }

    @Override
    public void clear() {
        this.queueThread.clear();
    }

    @Override
    public void waitUntilNotBusy() throws InterruptedException {
        this.queueThread.waitUntilNotBusy();
    }
}

