/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading.framework.internal;

import com.swirlds.common.metrics.extensions.FractionalTimer;
import com.swirlds.common.metrics.extensions.StandardFractionalTimer;
import com.swirlds.common.threading.framework.config.QueueThreadMetricsConfiguration;
import com.swirlds.common.threading.framework.internal.AbstractQueueThreadConfiguration;
import edu.umd.cs.findbugs.annotations.NonNull;

public class QueueThreadMetrics {
    private final FractionalTimer busyTime;

    public QueueThreadMetrics(@NonNull AbstractQueueThreadConfiguration<?, ?> configuration) {
        QueueThreadMetricsConfiguration metricsConfig = configuration.getMetricsConfiguration();
        if (metricsConfig == null || !metricsConfig.isBusyTimeMetricEnabled()) {
            this.busyTime = null;
            return;
        }
        this.busyTime = new StandardFractionalTimer(metricsConfig.getTime());
        this.busyTime.registerMetric(metricsConfig.getMetrics(), metricsConfig.getCategory(), QueueThreadMetrics.buildBusyTimeMetricName(configuration.getThreadName()), "The busy time of the queue thread called " + configuration.getThreadName());
    }

    public static String buildBusyTimeMetricName(@NonNull String threadName) {
        return "thread-busy-" + threadName;
    }

    public void startingWork() {
        if (this.busyTime != null) {
            this.busyTime.activate();
        }
    }

    public void finishedWork() {
        if (this.busyTime != null) {
            this.busyTime.deactivate();
        }
    }
}

