/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading.locks.internal;

import com.swirlds.common.threading.locks.AutoClosableLock;
import com.swirlds.common.threading.locks.locked.Locked;
import com.swirlds.common.threading.locks.locked.MaybeLocked;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class AutoLock
implements AutoClosableLock {
    private final Lock lock = new ReentrantLock();

    @Override
    @NonNull
    public Locked lock() {
        this.lock.lock();
        return this.lock::unlock;
    }

    @Override
    @NonNull
    public Locked lockInterruptibly() throws InterruptedException {
        this.lock.lockInterruptibly();
        return this.lock::unlock;
    }

    @Override
    @NonNull
    public MaybeLocked tryLock() {
        final boolean locked = this.lock.tryLock();
        return new MaybeLocked(){

            @Override
            public boolean isLockAcquired() {
                return locked;
            }

            @Override
            public void close() {
                if (locked) {
                    AutoLock.this.lock.unlock();
                }
            }
        };
    }

    @Override
    @NonNull
    public MaybeLocked tryLock(long time, TimeUnit unit) throws InterruptedException {
        final boolean locked = this.lock.tryLock(time, unit);
        return new MaybeLocked(){

            @Override
            public boolean isLockAcquired() {
                return locked;
            }

            @Override
            public void close() {
                if (locked) {
                    AutoLock.this.lock.unlock();
                }
            }
        };
    }

    @Override
    @NonNull
    public Condition newCondition() {
        return this.lock.newCondition();
    }
}

