/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading.utility;

import com.swirlds.common.threading.interrupt.InterruptableConsumer;
import com.swirlds.common.threading.utility.ThreadSleep;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;

public class SequenceCycle<T>
implements InterruptableConsumer<T> {
    private static final Duration DEFAULT_SLEEP = Duration.ofMillis(1L);
    private final InterruptableConsumer<T> consumer;
    private final ThreadSleep sleep;
    private final long sleepMillis;
    private final AtomicLong startedSequence = new AtomicLong(0L);
    private final AtomicLong endedSequence = new AtomicLong(0L);

    public SequenceCycle(InterruptableConsumer<T> consumer) {
        this(consumer, Thread::sleep);
    }

    public SequenceCycle(InterruptableConsumer<T> consumer, ThreadSleep sleep) {
        this(consumer, sleep, DEFAULT_SLEEP);
    }

    public SequenceCycle(InterruptableConsumer<T> consumer, ThreadSleep sleep, Duration sleepTime) {
        this.consumer = consumer;
        this.sleep = sleep;
        this.sleepMillis = sleepTime.toMillis();
    }

    @Override
    public void accept(T item) throws InterruptedException {
        this.startedSequence.incrementAndGet();
        try {
            this.consumer.accept(item);
        }
        finally {
            this.endedSequence.incrementAndGet();
        }
    }

    private long getSequenceStarted() {
        return this.startedSequence.get();
    }

    private void waitForSequenceEnd(long startSequence) throws InterruptedException {
        while (this.endedSequence.get() < startSequence) {
            this.sleep.sleep(this.sleepMillis);
        }
    }

    public void waitForCurrentSequenceEnd() throws InterruptedException {
        this.waitForSequenceEnd(this.getSequenceStarted());
    }
}

