/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.utility;

import com.swirlds.common.units.DataUnit;
import java.awt.Dialog;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Synthesizer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class CommonUtils {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static Synthesizer synthesizer;
    private static Clip clip;
    private static byte[] data;
    private static AudioFormat format;

    public static byte[] getNormalisedStringBytes(String s) {
        if (s == null) {
            return null;
        }
        return Normalizer.normalize(s, Normalizer.Form.NFD).getBytes(DEFAULT_CHARSET);
    }

    public static String getNormalisedStringFromBytes(byte[] bytes) {
        return new String(bytes, DEFAULT_CHARSET);
    }

    public static void beep() {
        CommonUtils.beep(60, 64, 20);
    }

    public static void beep(int pitch, int velocity, int duration) {
        try {
            if (synthesizer == null) {
                synthesizer = MidiSystem.getSynthesizer();
                synthesizer.open();
            }
            MidiChannel[] channels = synthesizer.getChannels();
            channels[0].noteOn(pitch, velocity);
            Thread.sleep(duration);
            channels[0].noteOff(60);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void click() {
        try {
            if (data == null) {
                data = new byte[]{0, 127};
                format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 1, 2, 44100.0f, false);
                clip = AudioSystem.getClip();
                clip.open(format, data, 0, data.length);
            }
            clip.start();
            while (clip.getFramePosition() < clip.getFrameLength()) {
                Thread.yield();
            }
            clip.stop();
            clip.setFramePosition(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void tellUserConsole(String msg) {
        System.out.println(msg);
    }

    public static void tellUserConsolePopup(String title, String msg) {
        CommonUtils.tellUserConsole("\n***** " + msg + " *****\n");
        if (!GraphicsEnvironment.isHeadless()) {
            String[] ss = msg.split("\n");
            int w = 0;
            for (String str : ss) {
                w = Math.max(w, str.length());
            }
            final JTextArea ta = new JTextArea(ss.length + 1, (int)((double)w * 0.65));
            ta.setText(msg);
            ta.setWrapStyleWord(true);
            ta.setLineWrap(true);
            ta.setCaretPosition(0);
            ta.setEditable(false);
            ta.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    Dialog dialog;
                    Window window = SwingUtilities.getWindowAncestor(ta);
                    if (window instanceof Dialog && !(dialog = (Dialog)window).isResizable()) {
                        dialog.setResizable(true);
                    }
                }
            });
            JScrollPane sp = new JScrollPane(ta);
            JOptionPane.showMessageDialog(null, sp, title, -1);
        }
    }

    public static String hex(byte[] bytes, int length) {
        if (bytes == null) {
            return "null";
        }
        CommonUtils.throwRangeInvalid("length", length, 0, bytes.length);
        char[] out = new char[length << 1];
        int j = 0;
        for (int i = 0; i < length; ++i) {
            out[j++] = DIGITS_LOWER[(0xF0 & bytes[i]) >>> 4];
            out[j++] = DIGITS_LOWER[0xF & bytes[i]];
        }
        return new String(out);
    }

    public static String hex(byte[] bytes) {
        return CommonUtils.hex(bytes, bytes == null ? 0 : bytes.length);
    }

    public static byte[] unhex(String string) {
        if (string == null) {
            return null;
        }
        char[] data = string.toCharArray();
        int len = data.length;
        if ((len & 1) != 0) {
            throw new IllegalArgumentException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = CommonUtils.toDigit(data[j], j) << 4;
            f |= CommonUtils.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    public static byte[] intToBytes(int value) {
        byte[] dst = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int shift = i * 8;
            dst[i] = (byte)(0xFF & value >> shift);
        }
        return dst;
    }

    private static int toDigit(char ch, int index) throws IllegalArgumentException {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new IllegalArgumentException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }

    public static void throwRangeInvalid(String name, int value, int minValue, int maxValue) {
        if (value < minValue || value > maxValue) {
            throw new IllegalArgumentException(String.format("The argument '%s' should have a value between %d and %d! Value provided is %d", name, minValue, maxValue, value));
        }
    }

    public static String nameToAlias(String name) {
        String alias = name.toLowerCase(Locale.ROOT);
        alias = Normalizer.normalize(alias, Normalizer.Form.NFD);
        alias = alias.replaceAll("[^\\p{L}0-9]", "");
        return alias;
    }

    @SafeVarargs
    public static <T> List<T> joinLists(List<T> ... lists) {
        return Arrays.stream(lists).flatMap(Collection::stream).toList();
    }

    public static String nullToBlank(String value) {
        return value == null ? "" : value;
    }

    @SafeVarargs
    public static <T> Consumer<T> combineConsumers(Consumer<T> ... consumers) {
        return t -> {
            for (Consumer consumer : consumers) {
                consumer.accept(t);
            }
        };
    }

    public static <T> Consumer<T> combineConsumers(List<Consumer<T>> consumers) {
        return t -> {
            for (Consumer consumer : consumers) {
                consumer.accept(t);
            }
        };
    }

    public static String byteCountToDisplaySize(long bytes) {
        return DataUnit.UNIT_BYTES.buildFormatter(bytes).setDecimalPlaces(1).render();
    }

    static {
        clip = null;
        data = null;
        format = null;
    }
}

