/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.utility.throttle;

public class Throttle {
    private volatile double tps;
    private volatile double burstPeriod;
    private volatile double capacity;
    private volatile double traffic;
    private volatile long lastTime;

    public Throttle(double tps) {
        this(tps, 1.0);
    }

    public Throttle(double tps, double burstPeriod) {
        this.tps = Math.max(0.0, tps);
        this.burstPeriod = Math.max(0.0, burstPeriod);
        this.capacity = tps * burstPeriod;
        this.traffic = 0.0;
        this.lastTime = System.nanoTime();
    }

    public synchronized double getCapacity() {
        return this.capacity;
    }

    public synchronized double getTps() {
        return this.tps;
    }

    public synchronized void setTps(double tps) {
        this.tps = Math.max(0.0, tps);
        this.capacity = this.tps * this.burstPeriod;
    }

    public synchronized double getBurstPeriod() {
        return this.burstPeriod;
    }

    public synchronized void setBurstPeriod(double burstPeriod) {
        this.burstPeriod = Math.max(0.0, burstPeriod);
        this.capacity = this.tps * this.burstPeriod;
    }

    public synchronized boolean allow() {
        return this.allow(1.0);
    }

    public synchronized boolean allow(double amount) {
        long t = System.nanoTime();
        this.traffic = Math.min(this.capacity, Math.max(0.0, this.traffic - (double)(t - this.lastTime) * this.tps * 1.0E-9));
        this.lastTime = t;
        if (amount < 0.0 || this.traffic + amount > this.capacity) {
            return false;
        }
        this.traffic += amount;
        return true;
    }
}

