/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.wiring.counters;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

class BackpressureBlocker
implements ForkJoinPool.ManagedBlocker {
    private final AtomicLong count;
    private final long capacity;
    private final long sleepNanos;

    public BackpressureBlocker(@NonNull AtomicLong count, long capacity, long sleepNanos) {
        this.count = Objects.requireNonNull(count);
        this.capacity = capacity;
        this.sleepNanos = sleepNanos;
    }

    @Override
    public boolean block() throws InterruptedException {
        if (this.sleepNanos > 0L) {
            try {
                TimeUnit.NANOSECONDS.sleep(this.sleepNanos);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return false;
    }

    @Override
    public boolean isReleasable() {
        long currentCount;
        boolean success;
        do {
            if ((currentCount = this.count.get()) < this.capacity) continue;
            return false;
        } while (!(success = this.count.compareAndSet(currentCount, currentCount + 1L)));
        return true;
    }
}

