/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.wiring.counters;

import com.swirlds.common.wiring.counters.BackpressureBlocker;
import com.swirlds.common.wiring.counters.EmptyBlocker;
import com.swirlds.common.wiring.counters.ObjectCounter;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicLong;

public class BackpressureObjectCounter
extends ObjectCounter {
    private final String name;
    private final AtomicLong count = new AtomicLong(0L);
    private final long capacity;
    private final ForkJoinPool.ManagedBlocker onRampBlocker;
    private final ForkJoinPool.ManagedBlocker waitUntilEmptyBlocker;

    public BackpressureObjectCounter(@NonNull String name, long capacity, @NonNull Duration sleepDuration) {
        if (capacity <= 0L) {
            throw new IllegalArgumentException("Capacity must be greater than zero");
        }
        this.name = Objects.requireNonNull(name);
        this.capacity = capacity;
        long sleepNanos = sleepDuration.toNanos();
        this.onRampBlocker = new BackpressureBlocker(this.count, capacity, sleepNanos);
        this.waitUntilEmptyBlocker = new EmptyBlocker(this.count, sleepNanos);
    }

    @Override
    public void onRamp() {
        boolean success;
        long currentCount = this.count.get();
        if (currentCount < this.capacity && (success = this.count.compareAndSet(currentCount, currentCount + 1L))) {
            return;
        }
        try {
            ForkJoinPool.managedBlock(this.onRampBlocker);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted while blocking on an onRamp() for " + this.name);
        }
    }

    @Override
    public boolean attemptOnRamp() {
        long currentCount;
        do {
            if ((currentCount = this.count.get()) < this.capacity) continue;
            return false;
        } while (!this.count.compareAndSet(currentCount, currentCount + 1L));
        return true;
    }

    @Override
    public void forceOnRamp() {
        this.count.incrementAndGet();
    }

    @Override
    public void offRamp() {
        this.count.decrementAndGet();
    }

    @Override
    public long getCount() {
        return this.count.get();
    }

    @Override
    public void waitUntilEmpty() {
        if (this.count.get() == 0L) {
            return;
        }
        try {
            ForkJoinPool.managedBlock(this.waitUntilEmptyBlocker);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted while blocking on an waitUntilEmpty() for " + this.name);
        }
    }
}

