/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.wiring.model.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MermaidStyleManager {
    private final Map<String, String> styleToStyleName = new HashMap<String, String>();
    private final Map<String, String> styleNameToStyle = new HashMap<String, String>();
    private final Map<String, List<String>> styleNameToClasses = new HashMap<String, List<String>>();

    public void registerStyle(@NonNull String name, @NonNull String style) {
        String styleName = this.styleToStyleName.computeIfAbsent(style, this::generateShortStyleName);
        this.styleNameToStyle.put(styleName, style);
        this.styleNameToClasses.computeIfAbsent(styleName, x -> new ArrayList()).add(name);
    }

    @NonNull
    private String generateShortStyleName(@NonNull String style) {
        return "s" + this.styleToStyleName.size();
    }

    public void render(@NonNull StringBuilder sb) {
        this.styleNameToStyle.keySet().stream().sorted().forEachOrdered(styleName -> {
            sb.append("classDef ").append((String)styleName).append(" ").append(this.styleNameToStyle.get(styleName)).append("\n");
            sb.append("class ");
            List<String> classNames = this.styleNameToClasses.get(styleName);
            Collections.sort(classNames);
            for (int i = 0; i < classNames.size(); ++i) {
                sb.append(classNames.get(i));
                if (i >= classNames.size() - 1) continue;
                sb.append(",");
            }
            sb.append(" ").append((String)styleName).append("\n");
        });
    }
}

