/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.wiring.model.internal;

import com.swirlds.common.utility.NonCryptographicHashing;
import com.swirlds.common.wiring.model.internal.MermaidNameShortener;
import com.swirlds.common.wiring.model.internal.ModelVertex;
import com.swirlds.common.wiring.model.internal.StandardVertex;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public class ModelEdge
implements Comparable<ModelEdge> {
    private ModelVertex source;
    private ModelVertex destination;
    private final String label;
    private final boolean insertionIsBlocking;
    private final boolean manual;

    public ModelEdge(@NonNull ModelVertex source, @NonNull ModelVertex destination, @NonNull String label, boolean insertionIsBlocking, boolean manual) {
        this.source = Objects.requireNonNull(source);
        this.destination = Objects.requireNonNull(destination);
        this.label = Objects.requireNonNull(label);
        this.insertionIsBlocking = insertionIsBlocking;
        this.manual = manual;
    }

    @NonNull
    public ModelVertex getSource() {
        return this.source;
    }

    public void setSource(@NonNull StandardVertex source) {
        this.source = Objects.requireNonNull(source);
    }

    @NonNull
    public ModelVertex getDestination() {
        return this.destination;
    }

    public void setDestination(@NonNull StandardVertex destination) {
        this.destination = Objects.requireNonNull(destination);
    }

    @NonNull
    public String getLabel() {
        return this.label;
    }

    public boolean isInsertionIsBlocking() {
        return this.insertionIsBlocking;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof ModelEdge) {
            ModelEdge that = (ModelEdge)obj;
            return this.source.equals(that.source) && this.destination.equals(that.destination) && this.label.equals(that.label);
        }
        return false;
    }

    public int hashCode() {
        return NonCryptographicHashing.hash32((long)this.source.hashCode(), (long)this.destination.hashCode(), (long)this.label.hashCode());
    }

    public String toString() {
        return String.valueOf(this.source) + " --" + this.label + "-->" + (this.insertionIsBlocking ? "" : ">") + " " + String.valueOf(this.destination);
    }

    @Override
    public int compareTo(@NonNull ModelEdge that) {
        if (!this.source.equals(that.source)) {
            return this.source.compareTo(that.source);
        }
        if (!this.destination.equals(that.destination)) {
            return this.destination.compareTo(that.destination);
        }
        return this.label.compareTo(that.label);
    }

    @NonNull
    private String getArrowCharacter() {
        if (this.manual) {
            return "o";
        }
        return ">";
    }

    public void render(@NonNull StringBuilder sb, @NonNull MermaidNameShortener nameProvider) {
        String sourceName = nameProvider.getShortVertexName(this.source.getName());
        sb.append(sourceName).append(" ");
        if (this.insertionIsBlocking) {
            if (this.label.isEmpty()) {
                sb.append("--");
            } else {
                sb.append("-- \"").append(this.label).append("\" --");
            }
        } else if (this.label.isEmpty()) {
            sb.append("-.-");
        } else {
            sb.append("-. \"").append(this.label).append("\" .-");
        }
        sb.append(this.getArrowCharacter()).append(" ");
        String destinationName = nameProvider.getShortVertexName(this.destination.getName());
        sb.append(destinationName).append("\n");
    }
}

