/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.wiring.model.internal;

import com.swirlds.common.wiring.model.internal.MermaidNameShortener;
import com.swirlds.common.wiring.model.internal.MermaidStyleManager;
import com.swirlds.common.wiring.model.internal.ModelEdge;
import com.swirlds.common.wiring.model.internal.ModelVertex;
import com.swirlds.common.wiring.model.internal.ModelVertexMetaType;
import com.swirlds.common.wiring.schedulers.builders.TaskSchedulerType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class StandardVertex
implements ModelVertex {
    private final String name;
    private final boolean insertionIsBlocking;
    private final TaskSchedulerType type;
    private final ModelVertexMetaType metaType;
    private final Set<ModelEdge> outgoingEdges = new HashSet<ModelEdge>();
    private final Set<String> substitutedInputs = new HashSet<String>();

    public StandardVertex(@NonNull String name, @NonNull TaskSchedulerType type, @NonNull ModelVertexMetaType metaType, boolean insertionIsBlocking) {
        this.name = Objects.requireNonNull(name);
        this.type = Objects.requireNonNull(type);
        this.metaType = Objects.requireNonNull(metaType);
        this.insertionIsBlocking = insertionIsBlocking;
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    @NonNull
    public TaskSchedulerType getType() {
        return this.type;
    }

    @Override
    public boolean isInsertionIsBlocking() {
        return this.insertionIsBlocking;
    }

    @Override
    @NonNull
    public Set<ModelEdge> getOutgoingEdges() {
        return this.outgoingEdges;
    }

    @Override
    @NonNull
    public Set<String> getSubstitutedInputs() {
        return this.substitutedInputs;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof StandardVertex) {
            StandardVertex that = (StandardVertex)obj;
            return this.name.equals(that.name);
        }
        return false;
    }

    public String toString() {
        if (this.insertionIsBlocking) {
            return "[" + this.name + "]";
        }
        return "(" + this.name + ")";
    }

    @NonNull
    private String generateStyle() {
        String color = switch (this.metaType) {
            default -> throw new MatchException(null, null);
            case ModelVertexMetaType.SUBSTITUTION -> "f88";
            case ModelVertexMetaType.GROUP -> "9cf";
            case ModelVertexMetaType.SCHEDULER -> {
                switch (this.type) {
                    case DIRECT: {
                        yield "ccc";
                    }
                    case DIRECT_STATELESS: {
                        yield "ccc";
                    }
                }
                yield "ff9";
            }
        };
        StringBuilder sb = new StringBuilder();
        sb.append("fill:#").append(color).append(",stroke:#").append("000").append(",stroke-width:2px");
        return sb.toString();
    }

    @Override
    public void render(@NonNull StringBuilder sb, @NonNull MermaidNameShortener nameProvider, @NonNull MermaidStyleManager styleManager) {
        String shortenedName = nameProvider.getShortVertexName(this.name);
        sb.append(shortenedName);
        block0 : switch (this.metaType) {
            case SUBSTITUTION: {
                sb.append("((");
                break;
            }
            case GROUP: {
                sb.append("[");
                break;
            }
            case SCHEDULER: {
                switch (this.type) {
                    case CONCURRENT: {
                        sb.append("[[");
                        break block0;
                    }
                    case DIRECT: {
                        sb.append("[/");
                        break block0;
                    }
                    case DIRECT_STATELESS: {
                        sb.append("{{");
                        break block0;
                    }
                }
                sb.append("[");
            }
        }
        sb.append("\"").append(this.name);
        if (!this.substitutedInputs.isEmpty()) {
            sb.append("<br />");
            this.substitutedInputs.stream().sorted().forEachOrdered(sb::append);
        }
        sb.append("\"");
        block10 : switch (this.metaType) {
            case SUBSTITUTION: {
                sb.append("))");
                break;
            }
            case GROUP: {
                sb.append("]");
                break;
            }
            case SCHEDULER: {
                switch (this.type) {
                    case CONCURRENT: {
                        sb.append("]]");
                        break block10;
                    }
                    case DIRECT: {
                        sb.append("/]");
                        break block10;
                    }
                    case DIRECT_STATELESS: {
                        sb.append("}}");
                        break block10;
                    }
                }
                sb.append("]");
            }
        }
        sb.append("\n");
        styleManager.registerStyle(shortenedName, this.generateStyle());
    }

    @Override
    public void setDepth(int depth) {
    }
}

