/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.wiring.model.internal;

import com.swirlds.base.time.Time;
import com.swirlds.common.metrics.Metrics;
import com.swirlds.common.wiring.model.ModelEdgeSubstitution;
import com.swirlds.common.wiring.model.ModelGroup;
import com.swirlds.common.wiring.model.ModelManualLink;
import com.swirlds.common.wiring.model.WiringModel;
import com.swirlds.common.wiring.model.internal.CycleFinder;
import com.swirlds.common.wiring.model.internal.DirectSchedulerChecks;
import com.swirlds.common.wiring.model.internal.InputWireChecks;
import com.swirlds.common.wiring.model.internal.InputWireDescriptor;
import com.swirlds.common.wiring.model.internal.ModelEdge;
import com.swirlds.common.wiring.model.internal.ModelVertex;
import com.swirlds.common.wiring.model.internal.ModelVertexMetaType;
import com.swirlds.common.wiring.model.internal.StandardVertex;
import com.swirlds.common.wiring.model.internal.WiringFlowchart;
import com.swirlds.common.wiring.schedulers.TaskScheduler;
import com.swirlds.common.wiring.schedulers.builders.TaskSchedulerBuilder;
import com.swirlds.common.wiring.schedulers.builders.TaskSchedulerMetricsBuilder;
import com.swirlds.common.wiring.schedulers.builders.TaskSchedulerType;
import com.swirlds.common.wiring.schedulers.internal.HeartbeatScheduler;
import com.swirlds.common.wiring.schedulers.internal.SequentialThreadTaskScheduler;
import com.swirlds.common.wiring.wires.SolderType;
import com.swirlds.common.wiring.wires.output.OutputWire;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class StandardWiringModel
implements WiringModel {
    private final Metrics metrics;
    private final Time time;
    private final Map<String, ModelVertex> vertices = new HashMap<String, ModelVertex>();
    private final Set<ModelEdge> edges = new HashSet<ModelEdge>();
    private HeartbeatScheduler heartbeatScheduler = null;
    private final List<SequentialThreadTaskScheduler<?>> threadSchedulers = new ArrayList();
    private final Set<InputWireDescriptor> inputWires = new HashSet<InputWireDescriptor>();
    private final Set<InputWireDescriptor> boundInputWires = new HashSet<InputWireDescriptor>();

    public StandardWiringModel(@NonNull Metrics metrics, @NonNull Time time) {
        this.metrics = Objects.requireNonNull(metrics);
        this.time = Objects.requireNonNull(time);
    }

    @Override
    @NonNull
    public final <O> TaskSchedulerBuilder<O> schedulerBuilder(@NonNull String name) {
        return new TaskSchedulerBuilder(this, name);
    }

    @Override
    @NonNull
    public final TaskSchedulerMetricsBuilder metricsBuilder() {
        return new TaskSchedulerMetricsBuilder(this.metrics, this.time);
    }

    @NonNull
    public OutputWire<Instant> buildHeartbeatWire(@NonNull Duration period) {
        return this.getHeartbeatScheduler().buildHeartbeatWire(period);
    }

    public OutputWire<Instant> buildHeartbeatWire(double frequency) {
        return this.getHeartbeatScheduler().buildHeartbeatWire(frequency);
    }

    @Override
    public boolean checkForCyclicalBackpressure() {
        return CycleFinder.checkForCyclicalBackPressure(this.vertices.values());
    }

    @Override
    public boolean checkForIllegalDirectSchedulerUsage() {
        return DirectSchedulerChecks.checkForIllegalDirectSchedulerUse(this.vertices.values());
    }

    @Override
    public boolean checkForUnboundInputWires() {
        return InputWireChecks.checkForUnboundInputWires(this.inputWires, this.boundInputWires);
    }

    @Override
    @NonNull
    public String generateWiringDiagram(@NonNull List<ModelGroup> groups, @NonNull List<ModelEdgeSubstitution> substitutions, @NonNull List<ModelManualLink> manualLinks) {
        WiringFlowchart flowchart = new WiringFlowchart(this.vertices, substitutions, groups, manualLinks);
        return flowchart.render();
    }

    public void registerScheduler(@NonNull TaskScheduler<?> scheduler) {
        this.registerVertex(scheduler.getName(), scheduler.getType(), scheduler.isInsertionBlocking());
        if (scheduler.getType() == TaskSchedulerType.SEQUENTIAL_THREAD) {
            this.threadSchedulers.add((SequentialThreadTaskScheduler)scheduler);
        }
    }

    public void registerVertex(@NonNull String vertexName, @NonNull TaskSchedulerType type, boolean insertionIsBlocking) {
        boolean unique;
        Objects.requireNonNull(vertexName);
        Objects.requireNonNull(type);
        boolean bl = unique = this.vertices.put(vertexName, new StandardVertex(vertexName, type, ModelVertexMetaType.SCHEDULER, insertionIsBlocking)) == null;
        if (!unique) {
            throw new IllegalArgumentException("Duplicate vertex name: " + vertexName);
        }
    }

    public void registerEdge(@NonNull String originVertex, @NonNull String destinationVertex, @NonNull String label, @NonNull SolderType solderType) {
        boolean blockingEdge = solderType == SolderType.PUT;
        ModelVertex origin = this.getVertex(originVertex);
        ModelVertex destination = this.getVertex(destinationVertex);
        boolean blocking = blockingEdge && destination.isInsertionIsBlocking();
        ModelEdge edge = new ModelEdge(origin, destination, label, blocking, false);
        origin.getOutgoingEdges().add(edge);
        boolean unique = this.edges.add(edge);
        if (!unique) {
            throw new IllegalArgumentException("Duplicate edge: " + originVertex + " -> " + destinationVertex + ", label = " + label);
        }
    }

    public void registerInputWireCreation(@NonNull String taskSchedulerName, @NonNull String inputWireName) {
        boolean unique = this.inputWires.add(new InputWireDescriptor(taskSchedulerName, inputWireName));
        if (!unique) {
            throw new IllegalStateException("Duplicate input wire " + inputWireName + " for scheduler " + taskSchedulerName);
        }
    }

    public void registerInputWireBinding(@NonNull String taskSchedulerName, @NonNull String inputWireName) {
        InputWireDescriptor descriptor = new InputWireDescriptor(taskSchedulerName, inputWireName);
        boolean registered = this.inputWires.contains(descriptor);
        if (!registered) {
            throw new IllegalStateException("Input wire " + inputWireName + " for scheduler " + taskSchedulerName + " was not registered");
        }
        boolean unique = this.boundInputWires.add(descriptor);
        if (!unique) {
            throw new IllegalStateException("Input wire " + inputWireName + " for scheduler " + taskSchedulerName + " should not be bound more than once");
        }
    }

    @Override
    public void start() {
        this.checkForCyclicalBackpressure();
        this.checkForIllegalDirectSchedulerUsage();
        this.checkForUnboundInputWires();
        if (this.heartbeatScheduler != null) {
            this.heartbeatScheduler.start();
        }
        for (SequentialThreadTaskScheduler<?> threadScheduler : this.threadSchedulers) {
            threadScheduler.start();
        }
    }

    @Override
    public void stop() {
        if (this.heartbeatScheduler != null) {
            this.heartbeatScheduler.stop();
        }
        for (SequentialThreadTaskScheduler<?> threadScheduler : this.threadSchedulers) {
            threadScheduler.stop();
        }
    }

    @NonNull
    private HeartbeatScheduler getHeartbeatScheduler() {
        if (this.heartbeatScheduler == null) {
            this.heartbeatScheduler = new HeartbeatScheduler(this, this.time, "heartbeat");
        }
        return this.heartbeatScheduler;
    }

    @NonNull
    private ModelVertex getVertex(@NonNull String vertexName) {
        ModelVertex vertex = this.vertices.get(vertexName);
        if (vertex != null) {
            return vertex;
        }
        StandardVertex adHocVertex = new StandardVertex(vertexName, TaskSchedulerType.DIRECT, ModelVertexMetaType.SCHEDULER, true);
        this.vertices.put(vertexName, adHocVertex);
        return adHocVertex;
    }
}

