/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.wiring.model.internal;

import com.swirlds.common.wiring.model.ModelEdgeSubstitution;
import com.swirlds.common.wiring.model.ModelGroup;
import com.swirlds.common.wiring.model.ModelManualLink;
import com.swirlds.common.wiring.model.internal.GroupVertex;
import com.swirlds.common.wiring.model.internal.MermaidNameShortener;
import com.swirlds.common.wiring.model.internal.MermaidStyleManager;
import com.swirlds.common.wiring.model.internal.ModelEdge;
import com.swirlds.common.wiring.model.internal.ModelVertex;
import com.swirlds.common.wiring.model.internal.ModelVertexMetaType;
import com.swirlds.common.wiring.model.internal.StandardVertex;
import com.swirlds.common.wiring.schedulers.builders.TaskSchedulerType;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class WiringFlowchart {
    public static final String SCHEDULER_COLOR = "ff9";
    public static final String DIRECT_SCHEDULER_COLOR = "ccc";
    public static final String TEXT_COLOR = "000";
    public static final String GROUP_COLOR = "9cf";
    public static final String SUBSTITUTION_COLOR = "f88";
    private final MermaidNameShortener nameProvider = new MermaidNameShortener();
    private final MermaidStyleManager styleManager = new MermaidStyleManager();
    private final Map<String, ModelVertex> vertexMap;

    public WiringFlowchart(@NonNull Map<String, ModelVertex> modelVertexMap, @NonNull List<ModelEdgeSubstitution> substitutions, @NonNull List<ModelGroup> groups, @NonNull List<ModelManualLink> manualLinks) {
        Objects.requireNonNull(modelVertexMap);
        this.vertexMap = this.copyVertexMap(modelVertexMap);
        this.addManualLinks(manualLinks);
        this.substituteEdges(substitutions);
        this.handleGroups(groups);
    }

    @NonNull
    private Map<String, ModelVertex> copyVertexMap(@NonNull Map<String, ModelVertex> original) {
        HashMap<String, ModelVertex> copy = new HashMap<String, ModelVertex>();
        for (ModelVertex vertex : original.values()) {
            if (!(vertex instanceof StandardVertex)) {
                throw new IllegalStateException("Encountered a vertex that is not a StandardVertex");
            }
            StandardVertex vertexCopy = new StandardVertex(vertex.getName(), vertex.getType(), ModelVertexMetaType.SCHEDULER, vertex.isInsertionIsBlocking());
            copy.put(vertex.getName(), vertexCopy);
        }
        for (ModelVertex vertex : original.values()) {
            for (ModelEdge edge : vertex.getOutgoingEdges()) {
                ModelVertex source = (ModelVertex)copy.get(edge.getSource().getName());
                ModelVertex destination = (ModelVertex)copy.get(edge.getDestination().getName());
                ModelEdge edgeCopy = new ModelEdge(source, destination, edge.getLabel(), edge.isInsertionIsBlocking(), false);
                source.getOutgoingEdges().add(edgeCopy);
            }
        }
        return copy;
    }

    private void addManualLinks(@NonNull List<ModelManualLink> manualLinks) {
        for (ModelManualLink link : manualLinks) {
            ModelVertex source = this.vertexMap.get(link.source());
            ModelVertex destination = this.vertexMap.get(link.target());
            if (source == null) {
                throw new IllegalStateException("Source vertex " + link.source() + " does not exist.");
            }
            if (destination == null) {
                throw new IllegalStateException("Destination vertex " + link.target() + " does not exist.");
            }
            ModelEdge edge = new ModelEdge(source, destination, link.label(), false, true);
            source.getOutgoingEdges().add(edge);
        }
    }

    private void substituteEdges(@NonNull List<ModelEdgeSubstitution> substitutions) {
        for (ModelEdgeSubstitution substitution : substitutions) {
            this.substituteEdge(substitution);
        }
    }

    private void substituteEdge(@NonNull ModelEdgeSubstitution substitution) {
        StandardVertex substitutedVertex = new StandardVertex(substitution.substitution(), TaskSchedulerType.DIRECT, ModelVertexMetaType.SUBSTITUTION, true);
        this.vertexMap.put(substitution.substitution(), substitutedVertex);
        for (ModelVertex vertex : this.vertexMap.values()) {
            if (!substitution.source().equals(vertex.getName())) continue;
            HashSet<ModelEdge> uniqueEdges = new HashSet<ModelEdge>();
            for (ModelEdge edge : vertex.getOutgoingEdges()) {
                if (!substitution.edge().equals(edge.getLabel())) {
                    vertex.getOutgoingEdges().add(edge);
                    continue;
                }
                edge.getDestination().getSubstitutedInputs().add(substitution.substitution());
                edge.setDestination(substitutedVertex);
                uniqueEdges.add(edge);
            }
            vertex.getOutgoingEdges().clear();
            vertex.getOutgoingEdges().addAll(uniqueEdges);
        }
    }

    private void handleGroups(@NonNull List<ModelGroup> groups) {
        for (ModelGroup group : groups) {
            GroupVertex groupVertex = this.createGroup(group);
            if (!group.collapse()) continue;
            this.collapseGroup(groupVertex);
        }
    }

    private GroupVertex createGroup(@NonNull ModelGroup group) {
        ArrayList<ModelVertex> subVertices = new ArrayList<ModelVertex>();
        for (String vertexName : group.elements()) {
            ModelVertex subVertex = this.vertexMap.get(vertexName);
            if (subVertex == null) {
                throw new IllegalStateException("Vertex " + vertexName + " is not in the vertex map. Can not insert into group " + group.name() + ".");
            }
            subVertices.add(subVertex);
        }
        for (ModelVertex subVertex : subVertices) {
            this.vertexMap.remove(subVertex.getName());
        }
        GroupVertex groupVertex = new GroupVertex(group.name(), subVertices);
        this.vertexMap.put(group.name(), groupVertex);
        return groupVertex;
    }

    private void collapseGroup(@NonNull GroupVertex group) {
        List<ModelEdge> edges = this.collectEdges();
        List<ModelVertex> groupVertices = this.collectGroupVertices(group);
        TaskSchedulerType schedulerType = this.getSchedulerTypeOfCollapsedGroup(groupVertices);
        StandardVertex newVertex = new StandardVertex(group.getName(), schedulerType, ModelVertexMetaType.SCHEDULER, true);
        for (ModelEdge edge : edges) {
            boolean collapsedSource = groupVertices.contains(edge.getSource());
            boolean collapsedDestination = groupVertices.contains(edge.getDestination());
            if (collapsedSource && collapsedDestination) continue;
            if (collapsedSource) {
                edge.setSource(newVertex);
                newVertex.getOutgoingEdges().add(edge);
            }
            if (!collapsedDestination) continue;
            edge.getSource().getOutgoingEdges().remove(edge);
            edge.setDestination(newVertex);
            edge.getSource().getOutgoingEdges().add(edge);
        }
        for (ModelVertex vertex : groupVertices) {
            for (String input : vertex.getSubstitutedInputs()) {
                newVertex.getSubstitutedInputs().add(input);
            }
        }
        for (ModelVertex vertex : groupVertices) {
            this.vertexMap.remove(vertex.getName());
        }
        this.vertexMap.put(newVertex.getName(), newVertex);
    }

    @NonNull
    private TaskSchedulerType getSchedulerTypeOfCollapsedGroup(@NonNull List<ModelVertex> groupVertices) {
        boolean hasSequential = false;
        boolean hasState = false;
        for (ModelVertex vertex : groupVertices) {
            if (vertex.getType() == TaskSchedulerType.CONCURRENT) {
                return TaskSchedulerType.CONCURRENT;
            }
            if (vertex.getType() == TaskSchedulerType.SEQUENTIAL || vertex.getType() == TaskSchedulerType.SEQUENTIAL_THREAD) {
                if (hasSequential) {
                    return TaskSchedulerType.CONCURRENT;
                }
                hasSequential = true;
            }
            if (vertex.getType() != TaskSchedulerType.DIRECT) continue;
            hasState = true;
        }
        if (hasSequential) {
            return TaskSchedulerType.SEQUENTIAL;
        }
        if (hasState) {
            return TaskSchedulerType.DIRECT;
        }
        return TaskSchedulerType.DIRECT_STATELESS;
    }

    private List<ModelVertex> collectGroupVertices(@NonNull GroupVertex group) {
        ArrayList<ModelVertex> vertices = new ArrayList<ModelVertex>();
        LinkedList<ModelVertex> stack = new LinkedList<ModelVertex>();
        stack.addLast(group);
        while (!stack.isEmpty()) {
            ModelVertex vertex = (ModelVertex)stack.removeLast();
            vertices.add(vertex);
            if (!(vertex instanceof GroupVertex)) continue;
            GroupVertex groupVertex = (GroupVertex)vertex;
            for (ModelVertex subVertex : groupVertex.getSubVertices()) {
                stack.addLast(subVertex);
            }
        }
        Collections.sort(vertices);
        return vertices;
    }

    private List<ModelEdge> collectEdges() {
        ArrayList<ModelEdge> edges = new ArrayList<ModelEdge>();
        LinkedList<ModelVertex> stack = new LinkedList<ModelVertex>();
        for (ModelVertex vertex : this.vertexMap.values()) {
            stack.addLast(vertex);
        }
        while (!stack.isEmpty()) {
            ModelVertex vertex = (ModelVertex)stack.removeLast();
            edges.addAll(vertex.getOutgoingEdges());
            if (!(vertex instanceof GroupVertex)) continue;
            GroupVertex groupVertex = (GroupVertex)vertex;
            for (ModelVertex subVertex : groupVertex.getSubVertices()) {
                stack.addLast(subVertex);
            }
        }
        Collections.sort(edges);
        return edges;
    }

    @NonNull
    public String render() {
        StringBuilder sb = new StringBuilder();
        sb.append("flowchart LR\n");
        List<ModelVertex> sortedVertices = this.vertexMap.values().stream().sorted().toList();
        for (ModelVertex vertex : sortedVertices) {
            vertex.render(sb, this.nameProvider, this.styleManager);
        }
        for (ModelEdge edge : this.collectEdges()) {
            edge.render(sb, this.nameProvider);
        }
        this.styleManager.render(sb);
        return sb.toString();
    }
}

