/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.wiring.schedulers.builders;

import com.swirlds.common.metrics.extensions.FractionalTimer;
import com.swirlds.common.metrics.extensions.NoOpFractionalTimer;
import com.swirlds.common.wiring.counters.BackpressureObjectCounter;
import com.swirlds.common.wiring.counters.MultiObjectCounter;
import com.swirlds.common.wiring.counters.NoOpObjectCounter;
import com.swirlds.common.wiring.counters.ObjectCounter;
import com.swirlds.common.wiring.counters.StandardObjectCounter;
import com.swirlds.common.wiring.model.internal.StandardWiringModel;
import com.swirlds.common.wiring.schedulers.TaskScheduler;
import com.swirlds.common.wiring.schedulers.builders.TaskSchedulerMetricsBuilder;
import com.swirlds.common.wiring.schedulers.builders.TaskSchedulerType;
import com.swirlds.common.wiring.schedulers.internal.ConcurrentTaskScheduler;
import com.swirlds.common.wiring.schedulers.internal.DirectTaskScheduler;
import com.swirlds.common.wiring.schedulers.internal.SequentialTaskScheduler;
import com.swirlds.common.wiring.schedulers.internal.SequentialThreadTaskScheduler;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ForkJoinPool;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskSchedulerBuilder<O> {
    private static final Logger logger = LogManager.getLogger(TaskSchedulerBuilder.class);
    public static final long UNLIMITED_CAPACITY = -1L;
    private final StandardWiringModel model;
    private TaskSchedulerType type = TaskSchedulerType.SEQUENTIAL;
    private final String name;
    private TaskSchedulerMetricsBuilder metricsBuilder;
    private long unhandledTaskCapacity = -1L;
    private boolean flushingEnabled = false;
    private boolean externalBackPressure = false;
    private ObjectCounter onRamp;
    private ObjectCounter offRamp;
    private ForkJoinPool pool = ForkJoinPool.commonPool();
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private Duration sleepDuration = Duration.ofNanos(100L);

    public TaskSchedulerBuilder(@NonNull StandardWiringModel model, @NonNull String name) {
        this.model = Objects.requireNonNull(model);
        if (!name.matches("^[a-zA-Z0-9_]*$")) {
            throw new IllegalArgumentException("Task Schedulers name must only contain alphanumeric characters and underscores");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("TaskScheduler name must not be empty");
        }
        this.name = name;
    }

    public TaskSchedulerBuilder<O> withType(@NonNull TaskSchedulerType type) {
        this.type = Objects.requireNonNull(type);
        return this;
    }

    @NonNull
    public TaskSchedulerBuilder<O> withUnhandledTaskCapacity(long unhandledTaskCapacity) {
        this.unhandledTaskCapacity = unhandledTaskCapacity;
        return this;
    }

    @NonNull
    public TaskSchedulerBuilder<O> withFlushingEnabled(boolean requireFlushCapability) {
        this.flushingEnabled = requireFlushCapability;
        return this;
    }

    @NonNull
    public TaskSchedulerBuilder<O> withOnRamp(@NonNull ObjectCounter onRamp) {
        this.onRamp = Objects.requireNonNull(onRamp);
        return this;
    }

    @NonNull
    public TaskSchedulerBuilder<O> withOffRamp(@NonNull ObjectCounter offRamp) {
        this.offRamp = Objects.requireNonNull(offRamp);
        return this;
    }

    public TaskSchedulerBuilder<O> withExternalBackPressure(boolean externalBackPressure) {
        this.externalBackPressure = externalBackPressure;
        return this;
    }

    @NonNull
    public TaskSchedulerBuilder<O> withSleepDuration(@NonNull Duration backpressureSleepDuration) {
        if (backpressureSleepDuration.isNegative()) {
            throw new IllegalArgumentException("Backpressure sleep duration must not be negative");
        }
        this.sleepDuration = backpressureSleepDuration;
        return this;
    }

    @NonNull
    public TaskSchedulerBuilder<O> withMetricsBuilder(@NonNull TaskSchedulerMetricsBuilder metricsBuilder) {
        this.metricsBuilder = Objects.requireNonNull(metricsBuilder);
        return this;
    }

    @NonNull
    public TaskSchedulerBuilder<O> withPool(@NonNull ForkJoinPool pool) {
        this.pool = Objects.requireNonNull(pool);
        return this;
    }

    @NonNull
    public TaskSchedulerBuilder<O> withUncaughtExceptionHandler(@NonNull Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = Objects.requireNonNull(uncaughtExceptionHandler);
        return this;
    }

    @NonNull
    private Thread.UncaughtExceptionHandler buildUncaughtExceptionHandler() {
        if (this.uncaughtExceptionHandler != null) {
            return this.uncaughtExceptionHandler;
        }
        return (thread, throwable) -> logger.error(LogMarker.EXCEPTION.getMarker(), "Uncaught exception in scheduler {}", (Object)this.name, (Object)throwable);
    }

    @NonNull
    private static ObjectCounter combineCounters(@Nullable ObjectCounter innerCounter, @Nullable ObjectCounter outerCounter) {
        if (innerCounter == null) {
            if (outerCounter == null) {
                return NoOpObjectCounter.getInstance();
            }
            return outerCounter;
        }
        if (outerCounter == null) {
            return innerCounter;
        }
        return new MultiObjectCounter(innerCounter, outerCounter);
    }

    @NonNull
    private Counters buildCounters() {
        ObjectCounter innerCounter = this.unhandledTaskCapacity != -1L ? new BackpressureObjectCounter(this.name, this.unhandledTaskCapacity, this.sleepDuration) : (this.metricsBuilder != null && this.metricsBuilder.isUnhandledTaskMetricEnabled() || this.type == TaskSchedulerType.CONCURRENT && this.flushingEnabled ? new StandardObjectCounter(this.sleepDuration) : null);
        return new Counters(TaskSchedulerBuilder.combineCounters(innerCounter, this.onRamp), TaskSchedulerBuilder.combineCounters(innerCounter, this.offRamp));
    }

    @NonNull
    private FractionalTimer buildBusyTimer() {
        if (this.metricsBuilder == null || !this.metricsBuilder.isBusyFractionMetricEnabled()) {
            return NoOpFractionalTimer.getInstance();
        }
        if (this.type == TaskSchedulerType.CONCURRENT) {
            throw new IllegalStateException("Busy fraction metric is not compatible with concurrent schedulers");
        }
        return this.metricsBuilder.buildBusyTimer();
    }

    @NonNull
    public TaskScheduler<O> build() {
        Counters counters = this.buildCounters();
        FractionalTimer busyFractionTimer = this.buildBusyTimer();
        if (this.metricsBuilder != null) {
            this.metricsBuilder.registerMetrics(this.name, counters.onRamp());
        }
        boolean insertionIsBlocking = this.unhandledTaskCapacity != -1L || this.externalBackPressure;
        TaskScheduler scheduler = switch (this.type) {
            default -> throw new MatchException(null, null);
            case TaskSchedulerType.CONCURRENT -> new ConcurrentTaskScheduler(this.model, this.name, this.pool, this.buildUncaughtExceptionHandler(), counters.onRamp(), counters.offRamp(), this.flushingEnabled, insertionIsBlocking);
            case TaskSchedulerType.SEQUENTIAL -> new SequentialTaskScheduler(this.model, this.name, this.pool, this.buildUncaughtExceptionHandler(), counters.onRamp(), counters.offRamp(), busyFractionTimer, this.flushingEnabled, insertionIsBlocking);
            case TaskSchedulerType.SEQUENTIAL_THREAD -> new SequentialThreadTaskScheduler(this.model, this.name, this.buildUncaughtExceptionHandler(), counters.onRamp(), counters.offRamp(), busyFractionTimer, this.sleepDuration, this.flushingEnabled, insertionIsBlocking);
            case TaskSchedulerType.DIRECT -> new DirectTaskScheduler(this.model, this.name, this.buildUncaughtExceptionHandler(), counters.onRamp(), counters.offRamp(), busyFractionTimer, false);
            case TaskSchedulerType.DIRECT_STATELESS -> new DirectTaskScheduler(this.model, this.name, this.buildUncaughtExceptionHandler(), counters.onRamp(), counters.offRamp(), busyFractionTimer, true);
        };
        this.model.registerScheduler(scheduler);
        return scheduler;
    }

    private record Counters(@NonNull ObjectCounter onRamp, @NonNull ObjectCounter offRamp) {
    }
}

