/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.wiring.schedulers.internal;

import com.swirlds.common.wiring.counters.ObjectCounter;
import com.swirlds.common.wiring.schedulers.internal.AbstractTask;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;

class ConcurrentTask
extends AbstractTask {
    private final Consumer<Object> handler;
    private final Object data;
    private final ObjectCounter offRamp;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

    protected ConcurrentTask(@NonNull ForkJoinPool pool, @NonNull ObjectCounter offRamp, @NonNull Thread.UncaughtExceptionHandler uncaughtExceptionHandler, @NonNull Consumer<Object> handler, @Nullable Object data) {
        super(pool, 0);
        this.handler = handler;
        this.data = data;
        this.offRamp = offRamp;
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    @Override
    protected boolean exec() {
        try {
            this.handler.accept(this.data);
        }
        catch (Throwable t) {
            this.uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), t);
        }
        finally {
            this.offRamp.offRamp();
        }
        return true;
    }
}

