/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.wiring.transformers;

import com.swirlds.common.wiring.model.WiringModel;
import com.swirlds.common.wiring.schedulers.TaskScheduler;
import com.swirlds.common.wiring.schedulers.builders.TaskSchedulerType;
import com.swirlds.common.wiring.wires.input.BindableInputWire;
import com.swirlds.common.wiring.wires.input.InputWire;
import com.swirlds.common.wiring.wires.output.OutputWire;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.function.Predicate;

public class WireFilter<T> {
    private final BindableInputWire<T, T> inputWire;
    private final OutputWire<T> outputWire;

    public WireFilter(@NonNull WiringModel model, @NonNull String filterName, @NonNull String filterInputName, @NonNull Predicate<T> predicate) {
        Objects.requireNonNull(predicate);
        TaskScheduler taskScheduler = model.schedulerBuilder(filterName).withType(TaskSchedulerType.DIRECT_STATELESS).build().cast();
        this.inputWire = taskScheduler.buildInputWire(filterInputName);
        this.inputWire.bind(t -> {
            if (predicate.test(t)) {
                return t;
            }
            return null;
        });
        this.outputWire = taskScheduler.getOutputWire();
    }

    @NonNull
    public InputWire<T> getInputWire() {
        return this.inputWire;
    }

    @NonNull
    public OutputWire<T> getOutputWire() {
        return this.outputWire;
    }
}

