/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.wiring.transformers;

import com.swirlds.common.wiring.model.WiringModel;
import com.swirlds.common.wiring.schedulers.TaskScheduler;
import com.swirlds.common.wiring.schedulers.builders.TaskSchedulerType;
import com.swirlds.common.wiring.wires.input.BindableInputWire;
import com.swirlds.common.wiring.wires.input.InputWire;
import com.swirlds.common.wiring.wires.output.OutputWire;
import com.swirlds.common.wiring.wires.output.StandardOutputWire;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;

public class WireListSplitter<T> {
    private final BindableInputWire<List<T>, T> inputWire;
    private final StandardOutputWire<T> outputWire;

    public WireListSplitter(@NonNull WiringModel model, @NonNull String splitterName, @NonNull String splitterInputName) {
        TaskScheduler taskScheduler = model.schedulerBuilder(splitterName).withType(TaskSchedulerType.DIRECT_STATELESS).build().cast();
        this.inputWire = taskScheduler.buildInputWire(splitterInputName);
        this.outputWire = (StandardOutputWire)taskScheduler.getOutputWire();
        this.inputWire.bind(list -> {
            for (Object t : list) {
                this.outputWire.forward((T)t);
            }
        });
    }

    @NonNull
    public InputWire<List<T>> getInputWire() {
        return this.inputWire;
    }

    @NonNull
    public OutputWire<T> getOutputWire() {
        return this.outputWire;
    }
}

