/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.wiring.transformers.internal;

import com.swirlds.common.wiring.model.internal.StandardWiringModel;
import com.swirlds.common.wiring.schedulers.builders.TaskSchedulerType;
import com.swirlds.common.wiring.wires.output.OutputWire;
import com.swirlds.common.wiring.wires.output.internal.ForwardingOutputWire;
import com.swirlds.common.wiring.wires.output.internal.TransformingOutputWire;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.function.Consumer;
import java.util.function.Function;

public class AdvancedWireTransformer<A, B>
implements Consumer<A> {
    private final ForwardingOutputWire<A, B> outputWire;

    public AdvancedWireTransformer(@NonNull StandardWiringModel model, @NonNull String name, @NonNull Function<A, B> transformer, @Nullable Consumer<A> cleanup) {
        model.registerVertex(name, TaskSchedulerType.DIRECT_STATELESS, true);
        this.outputWire = new TransformingOutputWire<A, B>(model, name, transformer, cleanup);
    }

    @Override
    public void accept(@NonNull A a) {
        this.outputWire.forward(a);
    }

    @NonNull
    public OutputWire<B> getOutputWire() {
        return this.outputWire;
    }
}

