/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.wiring.wires.input;

import com.swirlds.common.wiring.model.internal.StandardWiringModel;
import com.swirlds.common.wiring.schedulers.TaskScheduler;
import com.swirlds.common.wiring.wires.input.Bindable;
import com.swirlds.common.wiring.wires.input.InputWire;
import com.swirlds.common.wiring.wires.input.TaskSchedulerInput;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public class BindableInputWire<IN, OUT>
extends InputWire<IN>
implements Bindable<IN, OUT> {
    private final TaskSchedulerInput<OUT> taskSchedulerInput;
    private final String taskSchedulerName;
    private final StandardWiringModel model;

    public BindableInputWire(@NonNull StandardWiringModel model, @NonNull TaskScheduler<OUT> taskScheduler, @NonNull String name) {
        super(taskScheduler, name);
        this.model = Objects.requireNonNull(model);
        this.taskSchedulerInput = Objects.requireNonNull(taskScheduler);
        this.taskSchedulerName = taskScheduler.getName();
        model.registerInputWireCreation(this.taskSchedulerName, name);
    }

    @Override
    public void bind(@NonNull Consumer<IN> handler) {
        Objects.requireNonNull(handler);
        this.setHandler(handler);
        this.model.registerInputWireBinding(this.taskSchedulerName, this.getName());
    }

    @Override
    public void bind(@NonNull Function<IN, OUT> handler) {
        Objects.requireNonNull(handler);
        this.setHandler(i -> {
            Object output = handler.apply(i);
            if (output != null) {
                this.taskSchedulerInput.forward(output);
            }
        });
        this.model.registerInputWireBinding(this.taskSchedulerName, this.getName());
    }
}

