/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.wiring.wires.output;

import com.swirlds.common.wiring.model.internal.StandardWiringModel;
import com.swirlds.common.wiring.wires.output.internal.ForwardingOutputWire;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StandardOutputWire<OUT>
extends ForwardingOutputWire<OUT, OUT> {
    private static final Logger logger = LogManager.getLogger(StandardOutputWire.class);
    private final List<Consumer<OUT>> forwardingDestinations = new ArrayList<Consumer<OUT>>();

    public StandardOutputWire(@NonNull StandardWiringModel model, @NonNull String name) {
        super(model, name);
    }

    @Override
    protected void addForwardingDestination(@NonNull Consumer<OUT> destination) {
        Objects.requireNonNull(destination);
        this.forwardingDestinations.add(destination);
    }

    @Override
    public void forward(@NonNull OUT data) {
        for (Consumer<OUT> destination : this.forwardingDestinations) {
            try {
                destination.accept(data);
            }
            catch (Exception e) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "Exception thrown on output wire {} while forwarding data {}", (Object)this.getName(), data, (Object)e);
            }
        }
    }
}

