/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.wiring.wires.output.internal;

import com.swirlds.common.wiring.model.internal.StandardWiringModel;
import com.swirlds.common.wiring.wires.output.internal.ForwardingOutputWire;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransformingOutputWire<IN, OUT>
extends ForwardingOutputWire<IN, OUT> {
    private static final Logger logger = LogManager.getLogger(TransformingOutputWire.class);
    private final List<Consumer<OUT>> forwardingDestinations = new ArrayList<Consumer<OUT>>();
    private final Function<IN, OUT> transform;
    private final Consumer<IN> cleanup;

    public TransformingOutputWire(@NonNull StandardWiringModel model, @NonNull String name, @NonNull Function<IN, OUT> transformer, @Nullable Consumer<IN> cleanup) {
        super(model, name);
        this.transform = Objects.requireNonNull(transformer);
        this.cleanup = cleanup == null ? data -> {} : cleanup;
    }

    @Override
    protected void addForwardingDestination(@NonNull Consumer<OUT> destination) {
        Objects.requireNonNull(destination);
        this.forwardingDestinations.add(destination);
    }

    @Override
    public void forward(@NonNull IN data) {
        for (Consumer<OUT> destination : this.forwardingDestinations) {
            try {
                OUT transformed = this.transform.apply(data);
                if (transformed == null) {
                    return;
                }
                destination.accept(transformed);
            }
            catch (Exception e) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "Exception thrown on output wire {} while forwarding data {}", (Object)this.getName(), data, (Object)e);
            }
        }
        this.cleanup.accept(data);
    }
}

