/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.config.api;

import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.converter.ConfigConverter;
import com.swirlds.config.api.intern.ConfigurationProvider;
import com.swirlds.config.api.source.ConfigSource;
import com.swirlds.config.api.validation.ConfigValidator;
import edu.umd.cs.findbugs.annotations.NonNull;

public interface ConfigurationBuilder {
    public static final int CUSTOM_PROPERTY_ORDINAL = 50;

    @NonNull
    public ConfigurationBuilder withSource(@NonNull ConfigSource var1) throws IllegalStateException;

    @NonNull
    public ConfigurationBuilder withSources(ConfigSource ... var1) throws IllegalStateException;

    @NonNull
    public ConfigurationBuilder withConverter(@NonNull ConfigConverter<?> var1) throws IllegalStateException;

    @NonNull
    public ConfigurationBuilder withConverters(ConfigConverter<?> ... var1) throws IllegalStateException;

    @NonNull
    public ConfigurationBuilder withValidator(@NonNull ConfigValidator var1) throws IllegalStateException;

    @NonNull
    public ConfigurationBuilder withValidators(ConfigValidator ... var1) throws IllegalStateException;

    @NonNull
    public <T extends Record> ConfigurationBuilder withConfigDataType(@NonNull Class<T> var1) throws IllegalStateException;

    @NonNull
    public ConfigurationBuilder withConfigDataTypes(Class<? extends Record> ... var1) throws IllegalStateException;

    @NonNull
    public ConfigurationBuilder withValue(@NonNull String var1, @NonNull String var2);

    @NonNull
    public Configuration build();

    @NonNull
    public static ConfigurationBuilder create() {
        return ConfigurationProvider.getInstance().createBuilder();
    }
}

