/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.config.extensions.sources;

import com.swirlds.base.ArgumentUtils;
import com.swirlds.config.extensions.sources.MappedConfigSource;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public record ConfigMapping(@NonNull String mappedName, @NonNull String originalName) {
    private static final Logger logger = LogManager.getLogger(MappedConfigSource.class);

    public ConfigMapping {
        ArgumentUtils.throwArgBlank((String)mappedName, (String)"mappedName");
        ArgumentUtils.throwArgBlank((String)originalName, (String)"originalName");
        if (Objects.equals(originalName, mappedName)) {
            throw new IllegalArgumentException("originalName and mappedName are the same (%s)! Will not create an mappedName".formatted(mappedName));
        }
    }

    @Override
    public String toString() {
        return "'" + this.mappedName + "'<->'" + this.originalName + "'";
    }
}

