/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.config.extensions.sources;

import com.swirlds.config.api.source.ConfigSource;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.NoSuchElementException;
import java.util.Set;

public class ThreadCountPropertyConfigSource
implements ConfigSource {
    private static final String ELEMENT_NOT_FOUND = "Element with name %s not found";
    private static final String THREAD_COUNT = String.valueOf(Runtime.getRuntime().availableProcessors());
    private static final Set<String> PROPERTY_NAMES = Set.of("fcHashMap.rebuildThreadCount");

    @NonNull
    public Set<String> getPropertyNames() {
        return PROPERTY_NAMES;
    }

    @Nullable
    public String getValue(@NonNull String propertyName) throws NoSuchElementException {
        if (PROPERTY_NAMES.contains(propertyName)) {
            return THREAD_COUNT;
        }
        throw new NoSuchElementException(ELEMENT_NOT_FOUND.formatted(propertyName));
    }
}

