/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.fchashmap;

import com.swirlds.common.FastCopyable;
import com.swirlds.common.ReferenceCountException;
import com.swirlds.common.utility.ValueReference;
import com.swirlds.fchashmap.internal.FCHashMapEntrySet;
import com.swirlds.fchashmap.internal.GarbageCollectionEvent;
import com.swirlds.fchashmap.internal.Mutation;
import java.util.AbstractMap;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class FCHashMap<K, V>
extends AbstractMap<K, V>
implements FastCopyable {
    private final long version;
    private boolean immutable;
    private final Map<K, Mutation<V>> data;
    private final Deque<FCHashMap<K, V>> copies;
    private final Deque<GarbageCollectionEvent<K>> garbageCollectionEvents;
    private final Lock garbageCollectionLock;
    private final AtomicInteger size;
    private final AtomicBoolean released = new AtomicBoolean(false);

    public FCHashMap() {
        this(0);
    }

    public FCHashMap(int capacity) {
        this.data = new ConcurrentHashMap<K, Mutation<V>>(capacity);
        this.copies = new ConcurrentLinkedDeque<FCHashMap<K, V>>();
        this.garbageCollectionEvents = new ConcurrentLinkedDeque<GarbageCollectionEvent<K>>();
        this.garbageCollectionLock = new ReentrantLock();
        this.immutable = false;
        this.version = 0L;
        this.size = new AtomicInteger(0);
        this.copies.add(this);
    }

    protected FCHashMap(FCHashMap<K, V> that) {
        this.data = that.data;
        this.copies = that.copies;
        this.garbageCollectionLock = that.garbageCollectionLock;
        this.garbageCollectionEvents = that.garbageCollectionEvents;
        this.size = new AtomicInteger(that.size.get());
        this.immutable = false;
        that.immutable = true;
        this.version = that.version + 1L;
        this.copies.add(this);
    }

    public FCHashMap<K, V> copy() {
        this.throwIfImmutable();
        this.throwIfReleased();
        return new FCHashMap<K, V>(this);
    }

    protected int copyCount() {
        return this.copies.size();
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public synchronized void release() {
        boolean previouslyReleased = this.released.getAndSet(true);
        if (previouslyReleased) {
            throw new ReferenceCountException("this object has already been released");
        }
        this.doGarbageCollection();
    }

    public boolean isReleased() {
        return this.released.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGarbageCollection() {
        if (!this.garbageCollectionLock.tryLock()) {
            return;
        }
        try {
            Iterator<FCHashMap<K, V>> iterator = this.copies.iterator();
            while (iterator.hasNext()) {
                GarbageCollectionEvent<K> event;
                FCHashMap<K, V> copy = iterator.next();
                if (!copy.isReleased()) {
                    return;
                }
                while ((event = this.garbageCollectionEvents.peekFirst()) != null && event.getVersion() <= copy.version) {
                    this.garbageCollectionEvents.pop();
                    this.cleanOldMutations(event.getKey(), copy.version);
                }
                iterator.remove();
            }
        }
        finally {
            this.garbageCollectionLock.unlock();
        }
    }

    private void cleanOldMutations(K key, long version) {
        this.data.compute(key, (k, mutationHead) -> {
            if (mutationHead == null) {
                return null;
            }
            Mutation parent = mutationHead;
            Mutation target = parent.getPrevious();
            while (target != null) {
                if (target.getVersion() <= version) {
                    parent.setPrevious(null);
                    break;
                }
                parent = target;
                target = parent.getPrevious();
            }
            if (mutationHead.getPrevious() == null && mutationHead.getValue() == null) {
                return null;
            }
            return mutationHead;
        });
    }

    private void registerGarbageCollectionEvent(K key, long version) {
        this.garbageCollectionEvents.addLast(new GarbageCollectionEvent<K>(key, version));
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public boolean containsKey(Object key) {
        Mutation<V> mutation = this.getMutationForCurrentVersion(key);
        return mutation != null && mutation.getValue() != null;
    }

    protected Mutation<V> getMutationForCurrentVersion(K key) {
        Mutation<V> mutation;
        for (mutation = this.data.get(key); mutation != null && mutation.getVersion() > this.version; mutation = mutation.getPrevious()) {
        }
        return mutation;
    }

    private V mutate(K key, V value) {
        this.throwIfImmutable();
        ValueReference originalValueReference = new ValueReference();
        ValueReference requiresGarbageCollection = new ValueReference((Object)false);
        this.data.compute(key, (k, mutationHead) -> {
            Mutation<Object> mutation;
            originalValueReference.setValue(mutationHead == null ? null : mutationHead.getValue());
            if (mutationHead != null && mutationHead.getVersion() == this.version) {
                mutation = mutationHead;
                mutation.setValue(value);
            } else {
                mutation = new Mutation<Object>(this.version, value, (Mutation<Object>)mutationHead);
                if (mutationHead != null) {
                    requiresGarbageCollection.setValue((Object)true);
                }
            }
            if (value == null && mutation.getPrevious() == null) {
                return null;
            }
            return mutation;
        });
        Object originalValue = originalValueReference.getValue();
        if (originalValue == null && value != null) {
            this.size.getAndIncrement();
        } else if (originalValue != null && value == null) {
            this.size.getAndDecrement();
        }
        if (((Boolean)requiresGarbageCollection.getValue()).booleanValue()) {
            this.registerGarbageCollectionEvent(key, this.version - 1L);
        }
        return (V)originalValue;
    }

    public long version() {
        return this.version;
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            throw new NullPointerException("Null keys are not allowed");
        }
        Mutation<V> mutation = this.getMutationForCurrentVersion(key);
        return mutation == null ? null : (V)mutation.getValue();
    }

    public ModifiableValue<V> getForModify(K key) {
        ValueReference original = new ValueReference();
        Mutation mutation = this.data.compute(key, (k, mutationHead) -> {
            if (mutationHead == null) {
                return null;
            }
            original.setValue(mutationHead.getValue());
            if (mutationHead.getVersion() == this.version || mutationHead.getValue() == null) {
                return mutationHead;
            }
            return new Mutation<FastCopyable>(this.version, ((FastCopyable)mutationHead.getValue()).copy(), (Mutation<FastCopyable>)mutationHead);
        });
        if (mutation == null || mutation.getValue() == null) {
            return null;
        }
        if (mutation.getValue() != original.getValue()) {
            this.registerGarbageCollectionEvent(key, this.version - 1L);
        }
        return new ModifiableValue<Object>(mutation.getValue(), original.getValue());
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            throw new NullPointerException("null keys are not supported");
        }
        if (value == null) {
            throw new NullPointerException("null values are not supported");
        }
        return this.mutate(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.mutate(key, null);
    }

    @Override
    public void clear() {
        for (Object k : this.keySet()) {
            this.remove(k);
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new FCHashMapEntrySet<K, V>(this, this.data);
    }

    protected Map<K, Mutation<V>> getData() {
        return this.data;
    }

    public record ModifiableValue<V>(V value, V original) {
    }
}

