/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.fchashmap;

import com.swirlds.fchashmap.FCHashMapSettings;
import java.time.Duration;

public final class FCHashMapSettingsFactory {
    private static FCHashMapSettings settings;

    private FCHashMapSettingsFactory() {
    }

    public static void configure(FCHashMapSettings settings) {
        FCHashMapSettingsFactory.settings = settings;
    }

    public static FCHashMapSettings get() {
        if (settings == null) {
            settings = FCHashMapSettingsFactory.getDefaultSettings();
        }
        return settings;
    }

    private static FCHashMapSettings getDefaultSettings() {
        return new FCHashMapSettings(){

            @Override
            public int getMaximumGCQueueSize() {
                return 200;
            }

            @Override
            public Duration getGCQueueThresholdPeriod() {
                return Duration.ofMinutes(1L);
            }

            @Override
            public boolean isArchiveEnabled() {
                return true;
            }
        };
    }
}

