/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.fchashmap;

import com.swirlds.common.FastCopyable;
import com.swirlds.fchashmap.FCHashMap;
import com.swirlds.fchashmap.FCOneToManyRelation;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class FCInvertibleHashMap<K, V>
extends AbstractMap<K, V>
implements FastCopyable {
    private final FCHashMap<K, V> map;
    private final FCOneToManyRelation<V, K> inverseRelation;
    private boolean immutable;

    public FCInvertibleHashMap() {
        this(0);
    }

    public FCInvertibleHashMap(int capacity) {
        this.map = new FCHashMap(capacity);
        this.inverseRelation = new FCOneToManyRelation();
        this.immutable = false;
    }

    private FCInvertibleHashMap(FCInvertibleHashMap<K, V> that) {
        this.map = that.map.copy();
        this.inverseRelation = that.inverseRelation.copy();
        that.immutable = true;
        this.immutable = false;
    }

    public FCInvertibleHashMap<K, V> copy() {
        return new FCInvertibleHashMap<K, V>(this);
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    private void throwIfNullKey(K key) {
        if (key == null) {
            throw new IllegalArgumentException("null keys are not supported");
        }
    }

    private void throwIfNullValue(V value) {
        if (value == null) {
            throw new IllegalArgumentException("null values are not supported");
        }
    }

    public Iterator<K> inverseGet(V value) {
        return this.inverseRelation.get(value);
    }

    public Iterator<K> inverseGet(V value, int startIndex) {
        return this.inverseRelation.get(value, startIndex);
    }

    public Iterator<K> inverseGet(V value, int startIndex, int endIndex) {
        return this.inverseRelation.get(value, startIndex, endIndex);
    }

    public List<K> inverseGetList(V value) {
        return this.inverseRelation.getList(value);
    }

    public List<K> inverseGetList(V value, int startIndex) {
        return this.inverseRelation.getList(value, startIndex);
    }

    public List<K> inverseGetList(V value, int startIndex, int endIndex) {
        return this.inverseRelation.getList(value, startIndex, endIndex);
    }

    public int getValueCount(V value) {
        this.throwIfNullValue(value);
        return this.inverseRelation.getCount(value);
    }

    public synchronized void release() {
        this.map.release();
        this.inverseRelation.release();
    }

    @Override
    public V put(K key, V value) {
        boolean disassociated;
        this.throwIfImmutable();
        this.throwIfNullKey(key);
        this.throwIfNullValue(value);
        V previousValue = this.map.get(key);
        if (Objects.equals(previousValue, value)) {
            return previousValue;
        }
        if (previousValue != null && !(disassociated = this.inverseRelation.disassociate(previousValue, key))) {
            throw new IllegalStateException("unsuccessful disassociation");
        }
        this.map.put(key, value);
        boolean associated = this.inverseRelation.associate(value, key);
        if (!associated) {
            throw new IllegalStateException("unsuccessful association");
        }
        return previousValue;
    }

    @Override
    public V remove(Object key) {
        boolean disassociated;
        this.throwIfImmutable();
        this.throwIfNullKey(key);
        V value = this.map.remove(key);
        if (value != null && !(disassociated = this.inverseRelation.disassociate(value, key))) {
            throw new IllegalStateException("unsuccessful disassociation");
        }
        return value;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }
}

