/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.fchashmap;

import com.swirlds.common.FastCopyable;
import com.swirlds.fchashmap.FCHashMap;
import com.swirlds.fchashmap.internal.FCOneToManyRelationIterator;
import com.swirlds.fchashmap.internal.KeyIndexPair;
import com.swirlds.fchashmap.internal.KeyValuePair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FCOneToManyRelation<K, V>
implements FastCopyable {
    private final FCHashMap<KeyIndexPair<K>, V> associationMap;
    private final FCHashMap<K, Integer> associationCountMap;
    private Map<KeyValuePair<K, V>, Integer> indexMap;
    private boolean immutable;
    private boolean released;

    public FCOneToManyRelation() {
        this.associationMap = new FCHashMap();
        this.associationCountMap = new FCHashMap();
        this.indexMap = new HashMap<KeyValuePair<K, V>, Integer>();
        this.immutable = false;
    }

    private FCOneToManyRelation(FCOneToManyRelation<K, V> that) {
        this.associationMap = that.associationMap.copy();
        this.associationCountMap = that.associationCountMap.copy();
        this.indexMap = that.indexMap;
        that.indexMap = null;
        that.immutable = true;
        this.immutable = false;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public FCOneToManyRelation<K, V> copy() {
        this.throwIfImmutable();
        return new FCOneToManyRelation<K, V>(this);
    }

    public void release() {
        this.throwIfReleased();
        this.associationMap.release();
        this.associationCountMap.release();
        this.released = true;
    }

    public boolean isReleased() {
        return this.released;
    }

    private void throwIfNullKey(K key) {
        if (key == null) {
            throw new IllegalArgumentException("null keys are not supported");
        }
    }

    private void throwIfNullValue(V value) {
        if (value == null) {
            throw new IllegalArgumentException("null values are not supported");
        }
    }

    public boolean associate(K key, V value) {
        this.throwIfImmutable();
        this.throwIfNullKey(key);
        this.throwIfNullValue(value);
        KeyValuePair<K, V> association = new KeyValuePair<K, V>(key, value);
        if (this.isAssociated(association)) {
            return false;
        }
        int index = this.associationCountMap.getOrDefault(key, 0);
        this.associationMap.put(new KeyIndexPair<K>(key, index), value);
        this.associationCountMap.put(key, index + 1);
        this.indexMap.put(association, index);
        return true;
    }

    public boolean disassociate(K key, V value) {
        this.throwIfImmutable();
        this.throwIfNullKey(key);
        this.throwIfNullValue(value);
        KeyValuePair<K, V> associationToDissolve = new KeyValuePair<K, V>(key, value);
        if (!this.isAssociated(associationToDissolve)) {
            return false;
        }
        int indexToRemove = this.indexMap.get(associationToDissolve);
        int maxIndex = this.associationCountMap.get(key) - 1;
        KeyIndexPair<K> keyIndexPairToRemove = new KeyIndexPair<K>(key, indexToRemove);
        if (indexToRemove == maxIndex) {
            this.associationMap.remove(keyIndexPairToRemove);
        } else {
            V gapFillingValue = this.associationMap.remove(new KeyIndexPair<K>(key, maxIndex));
            this.associationMap.put(keyIndexPairToRemove, gapFillingValue);
            this.indexMap.put(new KeyValuePair<K, V>(key, gapFillingValue), indexToRemove);
        }
        if (maxIndex == 0) {
            this.associationCountMap.remove(key);
        } else {
            this.associationCountMap.put(key, maxIndex);
        }
        this.indexMap.remove(associationToDissolve);
        return true;
    }

    private boolean isAssociated(KeyValuePair<K, V> association) {
        return this.indexMap.containsKey(association);
    }

    public Iterator<V> get(K key) {
        return this.get(key, 0, this.getCount(key));
    }

    public Iterator<V> get(K key, int startIndex) {
        return this.get(key, startIndex, this.getCount(key));
    }

    public Iterator<V> get(K key, int startIndex, int endIndex) {
        this.throwIfNullKey(key);
        if (startIndex < 0) {
            throw new IndexOutOfBoundsException("negative indices are not supported");
        }
        if (startIndex > endIndex) {
            throw new IndexOutOfBoundsException("start index exceeds end index");
        }
        int count = this.getCount(key);
        if (count < endIndex) {
            throw new IndexOutOfBoundsException("end index " + endIndex + " requested but there " + (count == 1 ? "is" : "are") + " " + count + " " + (count == 1 ? "entry" : "entries"));
        }
        return new FCOneToManyRelationIterator<K, V>(this.associationMap, key, startIndex, endIndex);
    }

    public List<V> getList(K key) {
        return this.getList(key, 0, this.getCount(key));
    }

    public List<V> getList(K key, int startIndex) {
        return this.getList(key, startIndex, this.getCount(key));
    }

    public List<V> getList(K key, int startIndex, int endIndex) {
        ArrayList list = new ArrayList(this.getCount(key));
        Iterator<V> iterator = this.get(key, startIndex, endIndex);
        iterator.forEachRemaining(list::add);
        return list;
    }

    public int getCount(K key) {
        this.throwIfNullKey(key);
        Integer count = this.associationCountMap.get(key);
        if (count == null) {
            return 0;
        }
        return count;
    }

    public int getKeyCount() {
        return this.associationCountMap.size();
    }

    public Set<K> getKeySet() {
        return this.associationCountMap.keySet();
    }
}

