/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.fchashmap.internal;

import java.util.Objects;

public class KeyIndexPair<K> {
    private final K key;
    private final int index;

    public KeyIndexPair(K key, int index) {
        if (key == null) {
            throw new NullPointerException("null keys are not supported");
        }
        this.key = key;
        this.index = index;
    }

    public K getKey() {
        return this.key;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyIndexPair that = (KeyIndexPair)o;
        return this.index == that.index && Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return this.key.hashCode() * 37 + this.index;
    }

    public String toString() {
        return "(" + this.key + ", " + this.index + ")";
    }
}

