/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.fchashmap.internal;

import java.util.Objects;

public class KeyValuePair<K, V> {
    private final K key;
    private final V value;

    public KeyValuePair(K key, V value) {
        if (key == null) {
            throw new NullPointerException("null keys are not supported");
        }
        this.key = key;
        this.value = value;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyValuePair that = (KeyValuePair)o;
        return this.key.equals(that.key) && this.value.equals(that.value);
    }

    public int hashCode() {
        return this.key.hashCode() * 37 + Objects.hashCode(this.value.hashCode());
    }

    public String toString() {
        return "(" + this.key + ", " + this.value + ")";
    }
}

